/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.util.RocksDBDAO;
import org.apache.hudi.exception.HoodieNotSupportedException;

public final class RocksDBBasedMap<K extends Serializable, R extends Serializable>
implements Map<K, R> {
    private static final String COL_FAMILY_NAME = "map_handle";
    private final String rocksDbStoragePath;
    private RocksDBDAO rocksDBDAO;
    private final String columnFamilyName;

    public RocksDBBasedMap(String rocksDbStoragePath) {
        this.rocksDbStoragePath = rocksDbStoragePath;
        this.columnFamilyName = COL_FAMILY_NAME;
    }

    @Override
    public int size() {
        return (int)this.getRocksDBDAO().prefixSearch(this.columnFamilyName, "").count();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getRocksDBDAO().get(this.columnFamilyName, key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new HoodieNotSupportedException("Not Supported");
    }

    @Override
    public R get(Object key) {
        return (R)this.getRocksDBDAO().get(this.columnFamilyName, (Serializable)key);
    }

    @Override
    public R put(K key, R value) {
        this.getRocksDBDAO().put(this.columnFamilyName, key, value);
        return value;
    }

    @Override
    public R remove(Object key) {
        Object val = this.getRocksDBDAO().get(this.columnFamilyName, key.toString());
        this.getRocksDBDAO().delete(this.columnFamilyName, key.toString());
        return (R)val;
    }

    @Override
    public void putAll(Map<? extends K, ? extends R> m) {
        this.getRocksDBDAO().writeBatch(batch -> m.forEach((key, value) -> this.getRocksDBDAO().putInBatch(batch, this.columnFamilyName, key, value)));
    }

    private RocksDBDAO getRocksDBDAO() {
        if (null == this.rocksDBDAO) {
            this.rocksDBDAO = new RocksDBDAO("default", this.rocksDbStoragePath);
            this.rocksDBDAO.addColumnFamily(this.columnFamilyName);
        }
        return this.rocksDBDAO;
    }

    @Override
    public void clear() {
        if (null != this.rocksDBDAO) {
            this.rocksDBDAO.close();
        }
        this.rocksDBDAO = null;
    }

    @Override
    public Set<K> keySet() {
        throw new HoodieNotSupportedException("Not Supported");
    }

    @Override
    public Collection<R> values() {
        throw new HoodieNotSupportedException("Not Supported");
    }

    @Override
    public Set<Map.Entry<K, R>> entrySet() {
        throw new HoodieNotSupportedException("Not Supported");
    }

    public Iterator<R> iterator() {
        return this.getRocksDBDAO().prefixSearch(this.columnFamilyName, "").map(p -> (Serializable)p.getValue()).iterator();
    }
}

