/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class MetastoreContext {
    private final String username;
    private final String queryId;
    private final Optional<String> clientInfo;
    private final Optional<String> source;
    private final boolean impersonationEnabled;

    public MetastoreContext(ConnectorIdentity identity, String queryId, Optional<String> clientInfo, Optional<String> source) {
        this(Objects.requireNonNull(identity, "identity is null").getUser(), queryId, clientInfo, source);
    }

    public MetastoreContext(String username, String queryId, Optional<String> clientInfo, Optional<String> source) {
        this(username, queryId, clientInfo, source, false);
    }

    public MetastoreContext(String username, String queryId, Optional<String> clientInfo, Optional<String> source, boolean impersonationEnabled) {
        this.username = Objects.requireNonNull(username, "username is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.impersonationEnabled = impersonationEnabled;
    }

    public String getUsername() {
        return this.username;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("username", (Object)this.username).add("queryId", (Object)this.queryId).add("clientInfo", (Object)this.clientInfo.orElse("")).add("source", (Object)this.source.orElse("")).add("impersonationEnabled", (Object)Boolean.toString(this.impersonationEnabled)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetastoreContext other = (MetastoreContext)o;
        return Objects.equals(this.username, other.username) && Objects.equals(this.queryId, other.queryId) && Objects.equals(this.clientInfo, other.clientInfo) && Objects.equals(this.source, other.source) && this.impersonationEnabled == other.impersonationEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.username, this.queryId, this.clientInfo, this.source, this.impersonationEnabled);
    }
}

