/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PartitionMetadata {
    private final List<Column> columns;
    private final Map<String, String> parameters;
    private final Optional<HiveStorageFormat> storageFormat;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final Map<String, String> storageParameters;
    private final Map<String, String> serdeParameters;
    private final Optional<String> externalLocation;
    private final Map<String, HiveColumnStatistics> columnStatistics;
    private final boolean eligibleToIgnore;
    private final boolean sealedPartition;

    @JsonCreator
    public PartitionMetadata(@JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonProperty(value="storageFormat") Optional<HiveStorageFormat> storageFormat, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="storageParameters") Map<String, String> storageParameters, @JsonProperty(value="serdeParameters") Map<String, String> serdeParameters, @JsonProperty(value="externalLocation") Optional<String> externalLocation, @JsonProperty(value="columnStatistics") Map<String, HiveColumnStatistics> columnStatistics, @JsonProperty(value="eligibleToIgnore") boolean eligibleToIgnore, @JsonProperty(value="sealedPartition") boolean sealedPartition) {
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.storageParameters = ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(storageParameters, (Object)ImmutableMap.of())));
        this.serdeParameters = Objects.requireNonNull(serdeParameters, "serdeParameters is null");
        this.externalLocation = Objects.requireNonNull(externalLocation, "externalLocation is null");
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
        this.eligibleToIgnore = eligibleToIgnore;
        this.sealedPartition = sealedPartition;
    }

    public PartitionMetadata(Table table, PartitionWithStatistics partitionWithStatistics) {
        Partition partition = partitionWithStatistics.getPartition();
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        this.columns = partition.getColumns();
        this.parameters = MetastoreUtil.updateStatisticsParameters(partition.getParameters(), statistics.getBasicStatistics());
        StorageFormat tableFormat = partition.getStorage().getStorageFormat();
        this.storageFormat = Arrays.stream(HiveStorageFormat.values()).filter(format -> tableFormat.equals(StorageFormat.fromHiveStorageFormat(format))).findFirst();
        this.externalLocation = table.getTableType().equals((Object)PrestoTableType.EXTERNAL_TABLE) ? Optional.of(partition.getStorage().getLocation()) : Optional.empty();
        this.bucketProperty = partition.getStorage().getBucketProperty();
        this.storageParameters = partition.getStorage().getParameters();
        this.serdeParameters = partition.getStorage().getSerdeParameters();
        this.columnStatistics = ImmutableMap.copyOf(statistics.getColumnStatistics());
        this.eligibleToIgnore = partition.isEligibleToIgnore();
        this.sealedPartition = partition.isSealedPartition();
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonProperty
    public Optional<HiveStorageFormat> getStorageFormat() {
        return this.storageFormat;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public Map<String, String> getStorageParameters() {
        return this.storageParameters;
    }

    @JsonProperty
    public Map<String, String> getSerdeParameters() {
        return this.serdeParameters;
    }

    @JsonProperty
    public Optional<String> getExternalLocation() {
        return this.externalLocation;
    }

    @JsonProperty
    public Map<String, HiveColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    @JsonProperty
    public boolean isEligibleToIgnore() {
        return this.eligibleToIgnore;
    }

    @JsonProperty
    public boolean isSealedPartition() {
        return this.sealedPartition;
    }

    public PartitionMetadata withParameters(Map<String, String> parameters) {
        return new PartitionMetadata(this.columns, parameters, this.storageFormat, this.bucketProperty, this.storageParameters, this.serdeParameters, this.externalLocation, this.columnStatistics, this.eligibleToIgnore, this.sealedPartition);
    }

    public PartitionMetadata withColumnStatistics(Map<String, HiveColumnStatistics> columnStatistics) {
        return new PartitionMetadata(this.columns, this.parameters, this.storageFormat, this.bucketProperty, this.storageParameters, this.serdeParameters, this.externalLocation, columnStatistics, this.eligibleToIgnore, this.sealedPartition);
    }

    public Partition toPartition(String databaseName, String tableName, List<String> values, String location) {
        return new Partition(databaseName, tableName, values, Storage.builder().setLocation(this.externalLocation.orElse(location)).setStorageFormat(this.storageFormat.map(StorageFormat::fromHiveStorageFormat).orElse(StorageFormat.VIEW_STORAGE_FORMAT)).setBucketProperty(this.bucketProperty).setSerdeParameters(this.serdeParameters).setParameters(this.parameters).build(), this.columns, this.parameters, Optional.empty(), this.eligibleToIgnore, this.sealedPartition);
    }
}

