/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.ThriftConstructorInjection;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftMethodInjection;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftStructMetadata {
    private final String structName;
    private final Map<String, String> idlAnnotations;
    private final MetadataType metadataType;
    private final Optional<ThriftMethodInjection> builderMethod;
    private final ImmutableList<String> documentation;
    private final SortedMap<Short, ThriftFieldMetadata> fields;
    private final Optional<ThriftConstructorInjection> constructorInjection;
    private final List<ThriftMethodInjection> methodInjections;
    private final Type structType;
    private final Type builderType;

    public ThriftStructMetadata(String structName, Map<String, String> idlAnnotations, Type structType, Type builderType, MetadataType metadataType, Optional<ThriftMethodInjection> builderMethod, List<String> documentation, List<ThriftFieldMetadata> fields, Optional<ThriftConstructorInjection> constructorInjection, List<ThriftMethodInjection> methodInjections) {
        this.builderType = builderType;
        this.builderMethod = Objects.requireNonNull(builderMethod, "builderMethod is null");
        this.structName = Objects.requireNonNull(structName, "structName is null");
        this.idlAnnotations = Objects.requireNonNull(idlAnnotations, "idlAnnotations is null");
        this.metadataType = Objects.requireNonNull(metadataType, "metadataType is null");
        this.structType = Objects.requireNonNull(structType, "structType is null");
        this.constructorInjection = Objects.requireNonNull(constructorInjection, "constructorInjection is null");
        this.documentation = ImmutableList.copyOf((Collection)Objects.requireNonNull(documentation, "documentation is null"));
        this.fields = ImmutableSortedMap.copyOf((Map)Maps.uniqueIndex((Iterable)Objects.requireNonNull(fields, "fields is null"), ThriftFieldMetadata::getId));
        this.methodInjections = ImmutableList.copyOf((Collection)Objects.requireNonNull(methodInjections, "methodInjections is null"));
    }

    public String getStructName() {
        return this.structName;
    }

    public Type getStructType() {
        return this.structType;
    }

    public Class<?> getStructClass() {
        return TypeToken.of((Type)this.structType).getRawType();
    }

    public Type getBuilderType() {
        return this.builderType;
    }

    public Class<?> getBuilderClass() {
        return this.builderType == null ? null : TypeToken.of((Type)this.builderType).getRawType();
    }

    public MetadataType getMetadataType() {
        return this.metadataType;
    }

    public Optional<ThriftMethodInjection> getBuilderMethod() {
        return this.builderMethod;
    }

    public Map<String, String> getIdlAnnotations() {
        return this.idlAnnotations;
    }

    public ThriftFieldMetadata getField(int id) {
        return (ThriftFieldMetadata)this.fields.get((short)id);
    }

    public ImmutableList<String> getDocumentation() {
        return this.documentation;
    }

    public Collection<ThriftFieldMetadata> getFields(FieldKind type) {
        return this.getFields().stream().filter(field -> field.getType() == type).collect(Collectors.toList());
    }

    public Collection<ThriftFieldMetadata> getFields() {
        return this.fields.values();
    }

    public Optional<ThriftConstructorInjection> getConstructorInjection() {
        return this.constructorInjection;
    }

    public List<ThriftMethodInjection> getMethodInjections() {
        return this.methodInjections;
    }

    public boolean isException() {
        return Exception.class.isAssignableFrom(this.getStructClass());
    }

    public boolean isUnion() {
        return !this.isException() && this.getMetadataType() == MetadataType.UNION;
    }

    public boolean isStruct() {
        return !this.isException() && this.getMetadataType() == MetadataType.STRUCT;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("structName", (Object)this.structName).add("builderMethod", this.builderMethod).add("fields", this.fields).add("constructorInjection", this.constructorInjection).add("methodInjections", this.methodInjections).add("structType", (Object)this.structType).add("builderType", (Object)this.builderType).toString();
    }

    public static enum MetadataType {
        STRUCT,
        UNION;

    }
}

