/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.AlluxioFileInStream;
import alluxio.client.file.AlluxioFileOutStream;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.InStreamOptions;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.FileIncompleteException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.OpenDirectoryException;
import alluxio.grpc.Bits;
import alluxio.grpc.CheckAccessPOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.UnmountPOptions;
import alluxio.master.MasterInquireClient;
import alluxio.security.authorization.AclEntry;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.com.google.common.net.HostAndPort;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.uri.Authority;
import alluxio.util.FileSystemOptions;
import alluxio.wire.BlockLocation;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.MountPointInfo;
import alluxio.wire.SyncPointInfo;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BaseFileSystem
implements FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFileSystem.class);
    private final Closer mCloser = Closer.create();
    protected final FileSystemContext mFsContext;
    protected final AlluxioBlockStore mBlockStore;
    protected volatile boolean mClosed = false;

    public BaseFileSystem(FileSystemContext fsContext) {
        this.mFsContext = fsContext;
        this.mBlockStore = AlluxioBlockStore.create(fsContext);
        this.mCloser.register(this.mFsContext);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
        }
        this.mCloser.close();
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void checkAccess(AlluxioURI path, CheckAccessPOptions options) throws InvalidPathException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            CheckAccessPOptions mergedOptions = FileSystemOptions.checkAccessDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            client.checkAccess(path, mergedOptions);
            LOG.debug("Checked access {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            CreateDirectoryPOptions mergedOptions = FileSystemOptions.createDirectoryDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            client.createDirectory(path, mergedOptions);
            LOG.debug("Created directory {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public FileOutStream createFile(AlluxioURI path, CreateFilePOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        this.checkUri(path);
        return this.rpc(client -> {
            CreateFilePOptions mergedOptions = FileSystemOptions.createFileDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            URIStatus status = client.createFile(path, mergedOptions);
            LOG.debug("Created file {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            OutStreamOptions outStreamOptions = new OutStreamOptions(mergedOptions, this.mFsContext.getClientContext(), this.mFsContext.getPathConf(path));
            outStreamOptions.setUfsPath(status.getUfsPath());
            outStreamOptions.setMountId(status.getMountId());
            outStreamOptions.setAcl(status.getAcl());
            try {
                return new AlluxioFileOutStream(path, outStreamOptions, this.mFsContext);
            }
            catch (Exception e) {
                this.delete(path);
                throw e;
            }
        });
    }

    @Override
    public void delete(AlluxioURI path, DeletePOptions options) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            DeletePOptions mergedOptions = FileSystemOptions.deleteDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            client.delete(path, mergedOptions);
            LOG.debug("Deleted {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public boolean exists(AlluxioURI path, ExistsPOptions options) throws IOException, AlluxioException {
        this.checkUri(path);
        try {
            return this.rpc(client -> {
                ExistsPOptions mergedOptions = FileSystemOptions.existsDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
                client.getStatus(path, GrpcUtils.toGetStatusOptions(mergedOptions));
                return true;
            });
        }
        catch (FileDoesNotExistException | InvalidPathException e) {
            return false;
        }
    }

    @Override
    public void free(AlluxioURI path, FreePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            FreePOptions mergedOptions = FileSystemOptions.freeDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            client.free(path, mergedOptions);
            LOG.debug("Freed {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public List<BlockLocationInfo> getBlockLocations(AlluxioURI path) throws IOException, AlluxioException {
        ArrayList<BlockLocationInfo> blockLocations = new ArrayList<BlockLocationInfo>();
        List<FileBlockInfo> blocks = this.getStatus(path).getFileBlockInfos();
        for (FileBlockInfo fileBlockInfo : blocks) {
            List<WorkerNetAddress> locations = fileBlockInfo.getBlockInfo().getLocations().stream().map(BlockLocation::getWorkerAddress).collect(Collectors.toList());
            if (locations.isEmpty()) {
                if (!fileBlockInfo.getUfsLocations().isEmpty()) {
                    Map<String, WorkerNetAddress> finalWorkerHosts = this.getHostWorkerMap();
                    locations = fileBlockInfo.getUfsLocations().stream().map(location -> (WorkerNetAddress)finalWorkerHosts.get(HostAndPort.fromString(location).getHost())).filter(Objects::nonNull).collect(Collectors.toList());
                }
                if (locations.isEmpty() && this.mFsContext.getPathConf(path).getBoolean(PropertyKey.USER_UFS_BLOCK_LOCATION_ALL_FALLBACK_ENABLED)) {
                    locations.addAll(this.getHostWorkerMap().values());
                    Collections.shuffle(locations);
                }
            }
            blockLocations.add(new BlockLocationInfo(fileBlockInfo, locations));
        }
        return blockLocations;
    }

    private Map<String, WorkerNetAddress> getHostWorkerMap() throws IOException {
        List<BlockWorkerInfo> workers = this.mFsContext.getCachedWorkers();
        return workers.stream().collect(Collectors.toMap(worker -> worker.getNetAddress().getHost(), BlockWorkerInfo::getNetAddress, (worker1, worker2) -> worker1));
    }

    @Override
    public AlluxioConfiguration getConf() {
        return this.mFsContext.getClusterConf();
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        URIStatus status = this.rpc(client -> {
            GetStatusPOptions mergedOptions = FileSystemOptions.getStatusDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            return client.getStatus(path, mergedOptions);
        });
        if (!status.isCompleted()) {
            LOG.warn("File {} is not yet completed. getStatus will see incomplete metadata.", (Object)path);
        }
        return status;
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        return this.rpc(client -> {
            ListStatusPOptions mergedOptions = FileSystemOptions.listStatusDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            return client.listStatus(path, mergedOptions);
        });
    }

    @Override
    public void iterateStatus(AlluxioURI path, ListStatusPOptions options, Consumer<? super URIStatus> action) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            ListStatusPOptions mergedOptions = FileSystemOptions.listStatusDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            client.iterateStatus(path, mergedOptions, action);
            return null;
        });
    }

    @Override
    public void loadMetadata(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            ListStatusPOptions mergedOptions = FileSystemOptions.listStatusDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).setLoadMetadataType(LoadMetadataPType.ALWAYS).setLoadMetadataOnly(true).build();
            client.listStatus(path, mergedOptions);
            return null;
        });
    }

    @Override
    public void mount(AlluxioURI alluxioPath, AlluxioURI ufsPath, MountPOptions options) throws IOException, AlluxioException {
        this.checkUri(alluxioPath);
        this.rpc(client -> {
            MountPOptions mergedOptions = FileSystemOptions.mountDefaults(this.mFsContext.getPathConf(alluxioPath)).toBuilder().mergeFrom(options).build();
            client.mount(alluxioPath, ufsPath, mergedOptions);
            LOG.debug("Mount {} to {}", (Object)ufsPath, (Object)alluxioPath.getPath());
            return null;
        });
    }

    @Override
    public void updateMount(AlluxioURI alluxioPath, MountPOptions options) throws IOException, AlluxioException {
        this.checkUri(alluxioPath);
        this.rpc(client -> {
            MountPOptions mergedOptions = FileSystemOptions.mountDefaults(this.mFsContext.getPathConf(alluxioPath)).toBuilder().mergeFrom(options).build();
            client.updateMount(alluxioPath, mergedOptions);
            LOG.debug("UpdateMount on {}", (Object)alluxioPath.getPath());
            return null;
        });
    }

    @Override
    public Map<String, MountPointInfo> getMountTable() throws IOException, AlluxioException {
        return this.rpc(FileSystemMasterClient::getMountTable);
    }

    @Override
    public List<SyncPointInfo> getSyncPathList() throws IOException, AlluxioException {
        return this.rpc(FileSystemMasterClient::getSyncPathList);
    }

    @Override
    public void persist(AlluxioURI path, ScheduleAsyncPersistencePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            ScheduleAsyncPersistencePOptions mergedOptions = FileSystemOptions.scheduleAsyncPersistDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            client.scheduleAsyncPersist(path, mergedOptions);
            LOG.debug("Scheduled persist for {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException {
        this.checkUri(path);
        AlluxioConfiguration conf = this.mFsContext.getPathConf(path);
        URIStatus status = this.getStatus(path, FileSystemOptions.getStatusDefaults(conf).toBuilder().setAccessMode(Bits.READ).setUpdateTimestamps(options.getUpdateLastAccessTime()).build());
        return this.openFile(status, options);
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException {
        AlluxioURI path = new AlluxioURI(status.getPath());
        if (status.isFolder()) {
            throw new OpenDirectoryException(path);
        }
        if (!status.isCompleted()) {
            throw new FileIncompleteException(path);
        }
        AlluxioConfiguration conf = this.mFsContext.getPathConf(path);
        OpenFilePOptions mergedOptions = FileSystemOptions.openFileDefaults(conf).toBuilder().mergeFrom(options).build();
        InStreamOptions inStreamOptions = new InStreamOptions(status, mergedOptions, conf);
        return new AlluxioFileInStream(status, inStreamOptions, this.mFsContext);
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(src);
        this.checkUri(dst);
        this.rpc(client -> {
            RenamePOptions mergedOptions = FileSystemOptions.renameDefaults(this.mFsContext.getPathConf(dst)).toBuilder().mergeFrom(options).build();
            client.rename(src, dst, mergedOptions);
            LOG.debug("Renamed {} to {}, options: {}", new Object[]{src.getPath(), dst.getPath(), mergedOptions});
            return null;
        });
    }

    @Override
    public AlluxioURI reverseResolve(AlluxioURI ufsUri) throws IOException, AlluxioException {
        return this.rpc(client -> {
            AlluxioURI path = client.reverseResolve(ufsUri);
            LOG.debug("Reverse resolved {} to {}", (Object)ufsUri, (Object)path.getPath());
            return path;
        });
    }

    @Override
    public void setAcl(AlluxioURI path, SetAclAction action, List<AclEntry> entries, SetAclPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            SetAclPOptions mergedOptions = FileSystemOptions.setAclDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            client.setAcl(path, action, entries, mergedOptions);
            LOG.debug("Set ACL for {}, entries: {} options: {}", new Object[]{path.getPath(), entries, mergedOptions});
            return null;
        });
    }

    @Override
    public void setAttribute(AlluxioURI path, SetAttributePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        SetAttributePOptions mergedOptions = FileSystemOptions.setAttributeClientDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
        this.rpc(client -> {
            client.setAttribute(path, mergedOptions);
            LOG.debug("Set attributes for {}, options: {}", (Object)path.getPath(), (Object)options);
            return null;
        });
    }

    @Override
    public void startSync(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.rpc(client -> {
            client.startSync(path);
            LOG.debug("Start syncing for {}", (Object)path.getPath());
            return null;
        });
    }

    @Override
    public void stopSync(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.rpc(client -> {
            client.stopSync(path);
            LOG.debug("Stop syncing for {}", (Object)path.getPath());
            return null;
        });
    }

    @Override
    public void unmount(AlluxioURI path, UnmountPOptions options) throws IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            UnmountPOptions mergedOptions = FileSystemOptions.unmountDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            client.unmount(path);
            LOG.debug("Unmounted {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    protected void checkUri(AlluxioURI uri) {
        Preconditions.checkNotNull(uri, "uri");
        if (!this.mFsContext.getUriValidationEnabled()) {
            return;
        }
        if (uri.hasScheme()) {
            String warnMsg = "The URI scheme \"{}\" is ignored and not required in URIs passed to the Alluxio Filesystem client.";
            switch (uri.getScheme()) {
                case "alluxio": {
                    LOG.warn(warnMsg, (Object)"alluxio");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Scheme %s:// in AlluxioURI is invalid. Schemes in filesystem operations are ignored. \"alluxio://\" or no scheme at all is valid.", uri.getScheme()));
                }
            }
        }
        if (uri.hasAuthority()) {
            Authority configured;
            boolean skipAuthorityCheck;
            LOG.warn("The URI authority (hostname and port) is ignored and not required in URIs passed to the Alluxio Filesystem client.");
            AlluxioConfiguration conf = this.mFsContext.getClusterConf();
            boolean bl = skipAuthorityCheck = conf.isSet(PropertyKey.USER_SKIP_AUTHORITY_CHECK) && conf.getBoolean(PropertyKey.USER_SKIP_AUTHORITY_CHECK);
            if (!skipAuthorityCheck && !(configured = MasterInquireClient.Factory.create(this.mFsContext.getClusterConf(), this.mFsContext.getClientContext().getUserState()).getConnectDetails().toAuthority()).equals(uri.getAuthority())) {
                throw new IllegalArgumentException(String.format("The URI authority %s does not match the configured value of %s.", uri.getAuthority(), configured));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private <R> R rpc(RpcCallable<FileSystemMasterClient, R> fn) throws IOException, AlluxioException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    private static interface RpcCallable<T, R> {
        public R call(T var1) throws IOException, AlluxioException;
    }
}

