/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.collections.ConcurrentIdentityHashMap;
import alluxio.grpc.BufferRepository;
import alluxio.grpc.DataMessage;
import alluxio.grpc.GrpcSerializationUtils;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.shaded.client.io.grpc.Drainable;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.internal.CompositeReadableBuffer;
import alluxio.shaded.client.io.grpc.internal.ReadableBuffer;
import alluxio.shaded.client.io.grpc.internal.ReadableBuffers;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class DataMessageMarshaller<T>
implements MethodDescriptor.Marshaller<T>,
BufferRepository<T, DataBuffer> {
    private final MethodDescriptor.Marshaller<T> mOriginalMarshaller;
    private final Map<T, DataBuffer> mBufferMap = new ConcurrentIdentityHashMap<T, DataBuffer>();
    private volatile boolean mClosed = false;

    public DataMessageMarshaller(MethodDescriptor.Marshaller<T> originalMarshaller) {
        this.mOriginalMarshaller = originalMarshaller;
    }

    @Override
    public InputStream stream(T message) {
        return new DataBufferInputStream(message);
    }

    @Override
    public T parse(InputStream message) {
        ReadableBuffer rawBuffer = GrpcSerializationUtils.getBufferFromStream(message);
        try {
            if (rawBuffer != null) {
                CompositeReadableBuffer readableBuffer = new CompositeReadableBuffer();
                readableBuffer.addBuffer(rawBuffer);
                return this.deserialize(readableBuffer);
            }
            byte[] byteBuffer = new byte[message.available()];
            message.read(byteBuffer);
            return this.deserialize(ReadableBuffers.wrap(byteBuffer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.mClosed = true;
        for (DataBuffer buffer : this.mBufferMap.values()) {
            buffer.release();
        }
    }

    @Override
    public void offerBuffer(DataBuffer buffer, T message) {
        if (this.mClosed) {
            buffer.release();
            return;
        }
        this.mBufferMap.put(message, buffer);
    }

    @Override
    public DataBuffer pollBuffer(T message) {
        return this.mBufferMap.remove(message);
    }

    public abstract T combineData(DataMessage<T, DataBuffer> var1);

    protected abstract ByteBuf[] serialize(T var1) throws IOException;

    protected abstract T deserialize(ReadableBuffer var1) throws IOException;

    private class DataBufferInputStream
    extends InputStream
    implements Drainable {
        private final InputStream mStream;
        private final T mMessage;

        DataBufferInputStream(T message) {
            this.mMessage = message;
            this.mStream = DataMessageMarshaller.this.mOriginalMarshaller.stream(message);
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int drainTo(OutputStream target) throws IOException {
            ByteBuf[] buffers;
            int bytesWritten = 0;
            for (ByteBuf buffer : buffers = DataMessageMarshaller.this.serialize(this.mMessage)) {
                bytesWritten += buffer.readableBytes();
            }
            if (!GrpcSerializationUtils.addBuffersToStream(buffers, target)) {
                for (ByteBuf buffer : buffers) {
                    buffer.readBytes(target, buffer.readableBytes());
                }
            }
            return bytesWritten;
        }

        @Override
        public void close() throws IOException {
            this.mStream.close();
        }
    }
}

