/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.StreamLayout;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.OptionalInt;

public class OrcWriterOptions {
    public static final DataSize DEFAULT_STRIPE_MIN_SIZE = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    public static final DataSize DEFAULT_STRIPE_MAX_SIZE = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    public static final int DEFAULT_STRIPE_MAX_ROW_COUNT = 10000000;
    public static final int DEFAULT_ROW_GROUP_MAX_ROW_COUNT = 10000;
    public static final DataSize DEFAULT_DICTIONARY_MAX_MEMORY = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    public static final DataSize DEFAULT_MAX_STRING_STATISTICS_LIMIT = new DataSize(64.0, DataSize.Unit.BYTE);
    public static final DataSize DEFAULT_MAX_COMPRESSION_BUFFER_SIZE = new DataSize(256.0, DataSize.Unit.KILOBYTE);
    private final DataSize stripeMinSize;
    private final DataSize stripeMaxSize;
    private final int stripeMaxRowCount;
    private final int rowGroupMaxRowCount;
    private final DataSize dictionaryMaxMemory;
    private final DataSize maxStringStatisticsLimit;
    private final DataSize maxCompressionBufferSize;
    private final OptionalInt compressionLevel;
    private final StreamLayout streamLayout;
    private final boolean integerDictionaryEncodingEnabled;

    private OrcWriterOptions(DataSize stripeMinSize, DataSize stripeMaxSize, int stripeMaxRowCount, int rowGroupMaxRowCount, DataSize dictionaryMaxMemory, DataSize maxStringStatisticsLimit, DataSize maxCompressionBufferSize, OptionalInt compressionLevel, StreamLayout streamLayout, boolean integerDictionaryEncodingEnabled) {
        Objects.requireNonNull(stripeMinSize, "stripeMinSize is null");
        Objects.requireNonNull(stripeMaxSize, "stripeMaxSize is null");
        Preconditions.checkArgument((stripeMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMaxRowCount must be at least 1");
        Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
        Objects.requireNonNull(dictionaryMaxMemory, "dictionaryMaxMemory is null");
        Objects.requireNonNull(maxStringStatisticsLimit, "maxStringStatisticsLimit is null");
        Objects.requireNonNull(maxCompressionBufferSize, "maxCompressionBufferSize is null");
        Objects.requireNonNull(compressionLevel, "compressionLevel is null");
        Objects.requireNonNull(streamLayout, "streamLayout is null");
        this.stripeMinSize = stripeMinSize;
        this.stripeMaxSize = stripeMaxSize;
        this.stripeMaxRowCount = stripeMaxRowCount;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.dictionaryMaxMemory = dictionaryMaxMemory;
        this.maxStringStatisticsLimit = maxStringStatisticsLimit;
        this.maxCompressionBufferSize = maxCompressionBufferSize;
        this.compressionLevel = compressionLevel;
        this.streamLayout = streamLayout;
        this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
    }

    public DataSize getStripeMinSize() {
        return this.stripeMinSize;
    }

    public DataSize getStripeMaxSize() {
        return this.stripeMaxSize;
    }

    public int getStripeMaxRowCount() {
        return this.stripeMaxRowCount;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public DataSize getDictionaryMaxMemory() {
        return this.dictionaryMaxMemory;
    }

    public DataSize getMaxStringStatisticsLimit() {
        return this.maxStringStatisticsLimit;
    }

    public DataSize getMaxCompressionBufferSize() {
        return this.maxCompressionBufferSize;
    }

    public OptionalInt getCompressionLevel() {
        return this.compressionLevel;
    }

    public StreamLayout getStreamLayout() {
        return this.streamLayout;
    }

    public boolean isIntegerDictionaryEncodingEnabled() {
        return this.integerDictionaryEncodingEnabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stripeMinSize", (Object)this.stripeMinSize).add("stripeMaxSize", (Object)this.stripeMaxSize).add("stripeMaxRowCount", this.stripeMaxRowCount).add("rowGroupMaxRowCount", this.rowGroupMaxRowCount).add("dictionaryMaxMemory", (Object)this.dictionaryMaxMemory).add("maxStringStatisticsLimit", (Object)this.maxStringStatisticsLimit).add("maxCompressionBufferSize", (Object)this.maxCompressionBufferSize).add("compressionLevel", (Object)this.compressionLevel).add("streamLayout", (Object)this.streamLayout).add("integerDictionaryEncodingEnabled", this.integerDictionaryEncodingEnabled).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DataSize stripeMinSize = DEFAULT_STRIPE_MIN_SIZE;
        private DataSize stripeMaxSize = DEFAULT_STRIPE_MAX_SIZE;
        private int stripeMaxRowCount = 10000000;
        private int rowGroupMaxRowCount = 10000;
        private DataSize dictionaryMaxMemory = DEFAULT_DICTIONARY_MAX_MEMORY;
        private DataSize maxStringStatisticsLimit = DEFAULT_MAX_STRING_STATISTICS_LIMIT;
        private DataSize maxCompressionBufferSize = DEFAULT_MAX_COMPRESSION_BUFFER_SIZE;
        private OptionalInt compressionLevel = OptionalInt.empty();
        private StreamLayout streamLayout = new StreamLayout.ByStreamSize();
        private boolean integerDictionaryEncodingEnabled;

        public Builder withStripeMinSize(DataSize stripeMinSize) {
            this.stripeMinSize = Objects.requireNonNull(stripeMinSize, "stripeMinSize is null");
            return this;
        }

        public Builder withStripeMaxSize(DataSize stripeMaxSize) {
            this.stripeMaxSize = Objects.requireNonNull(stripeMaxSize, "stripeMaxSize is null");
            return this;
        }

        public Builder withStripeMaxRowCount(int stripeMaxRowCount) {
            Preconditions.checkArgument((stripeMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMaxRowCount must be at least 1");
            this.stripeMaxRowCount = stripeMaxRowCount;
            return this;
        }

        public Builder withRowGroupMaxRowCount(int rowGroupMaxRowCount) {
            Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
            this.rowGroupMaxRowCount = rowGroupMaxRowCount;
            return this;
        }

        public Builder withDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
            this.dictionaryMaxMemory = Objects.requireNonNull(dictionaryMaxMemory, "dictionaryMaxMemory is null");
            return this;
        }

        public Builder withMaxStringStatisticsLimit(DataSize maxStringStatisticsLimit) {
            this.maxStringStatisticsLimit = Objects.requireNonNull(maxStringStatisticsLimit, "maxStringStatisticsLimit is null");
            return this;
        }

        public Builder withMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
            this.maxCompressionBufferSize = Objects.requireNonNull(maxCompressionBufferSize, "maxCompressionBufferSize is null");
            return this;
        }

        public Builder withCompressionLevel(OptionalInt compressionLevel) {
            this.compressionLevel = Objects.requireNonNull(compressionLevel, "compressionLevel is null");
            return this;
        }

        public Builder withStreamLayout(StreamLayout streamLayout) {
            this.streamLayout = Objects.requireNonNull(streamLayout, "streamLayout is null");
            return this;
        }

        public Builder withIntegerDictionaryEncodingEnabled(boolean integerDictionaryEncodingEnabled) {
            this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
            return this;
        }

        public OrcWriterOptions build() {
            return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
        }
    }
}

