/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.orc.TupleDomainFilter;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TupleDomainFilterUtils {
    private TupleDomainFilterUtils() {
    }

    public static TupleDomainFilter toFilter(Domain domain) {
        ValueSet values = domain.getValues();
        boolean nullAllowed = domain.isNullAllowed();
        if (values.isAll()) {
            Preconditions.checkArgument((!nullAllowed ? 1 : 0) != 0, (Object)"Unexpected allways-true filter");
            return TupleDomainFilter.IS_NOT_NULL;
        }
        if (values.isNone()) {
            Preconditions.checkArgument((boolean)nullAllowed, (Object)"Unexpected allways-false filter");
            return TupleDomainFilter.IS_NULL;
        }
        Preconditions.checkArgument((boolean)(values instanceof SortedRangeSet), (Object)("Unexpected domain type: " + values.getClass().getSimpleName()));
        List ranges = ((SortedRangeSet)values).getOrderedRanges();
        if (ranges.isEmpty() && nullAllowed) {
            return TupleDomainFilter.IS_NULL;
        }
        Type type = domain.getType();
        if (ranges.size() == 1) {
            return TupleDomainFilterUtils.createRangeFilter(type, (Range)ranges.get(0), nullAllowed);
        }
        if (type == BooleanType.BOOLEAN) {
            return TupleDomainFilterUtils.createBooleanFilter(ranges, nullAllowed);
        }
        List rangeFilters = (List)ranges.stream().map(range -> TupleDomainFilterUtils.createRangeFilter(type, range, false)).filter((Predicate<TupleDomainFilter>)Predicates.not(TupleDomainFilter.ALWAYS_FALSE::equals)).collect(ImmutableList.toImmutableList());
        if (rangeFilters.isEmpty()) {
            return nullAllowed ? TupleDomainFilter.IS_NULL : TupleDomainFilter.ALWAYS_FALSE;
        }
        TupleDomainFilter firstRangeFilter = (TupleDomainFilter)rangeFilters.get(0);
        if (firstRangeFilter instanceof TupleDomainFilter.BigintRange) {
            List bigintRanges = (List)rangeFilters.stream().map(TupleDomainFilter.BigintRange.class::cast).collect(ImmutableList.toImmutableList());
            if (bigintRanges.stream().allMatch(TupleDomainFilter.BigintRange::isSingleValue)) {
                return TupleDomainFilterUtils.toBigintValues(bigintRanges.stream().mapToLong(TupleDomainFilter.BigintRange::getLower).toArray(), nullAllowed);
            }
            return TupleDomainFilter.BigintMultiRange.of(bigintRanges, nullAllowed);
        }
        if (firstRangeFilter instanceof TupleDomainFilter.BytesRange) {
            List bytesRanges = (List)rangeFilters.stream().map(TupleDomainFilter.BytesRange.class::cast).collect(ImmutableList.toImmutableList());
            if (bytesRanges.stream().allMatch(TupleDomainFilter.BytesRange::isSingleValue)) {
                return TupleDomainFilter.BytesValues.of((byte[][])bytesRanges.stream().map(TupleDomainFilter.BytesRange::getLower).toArray(x$0 -> new byte[x$0][]), nullAllowed);
            }
            if (TupleDomainFilterUtils.isNotIn(ranges)) {
                return TupleDomainFilter.BytesValuesExclusive.of((byte[][])bytesRanges.stream().map(TupleDomainFilter.BytesRange::getLower).filter(Objects::nonNull).toArray(x$0 -> new byte[x$0][]), nullAllowed);
            }
        }
        if (firstRangeFilter instanceof TupleDomainFilter.DoubleRange || firstRangeFilter instanceof TupleDomainFilter.FloatRange) {
            boolean nanAllowed = TupleDomainFilterUtils.isNotIn(ranges);
            return TupleDomainFilter.MultiRange.of(rangeFilters, nullAllowed, nanAllowed);
        }
        return TupleDomainFilter.MultiRange.of(rangeFilters, nullAllowed, false);
    }

    private static boolean isNotIn(List<Range> ranges) {
        if (ranges.size() <= 1) {
            return false;
        }
        Range firstRange = ranges.get(0);
        Marker previousHigh = firstRange.getHigh();
        Type type = previousHigh.getType();
        if (type != DoubleType.DOUBLE && type != RealType.REAL && !Varchars.isVarcharType((Type)type) && !(type instanceof CharType)) {
            return false;
        }
        Range lastRange = ranges.get(ranges.size() - 1);
        if (!firstRange.isLowUnbounded() || !lastRange.isHighUnbounded()) {
            return false;
        }
        for (int i = 1; i < ranges.size(); ++i) {
            Range current = ranges.get(i);
            if (previousHigh.getBound() != Marker.Bound.BELOW || current.getLow().getBound() != Marker.Bound.ABOVE || type.compareTo((Block)previousHigh.getValueBlock().get(), 0, (Block)current.getLow().getValueBlock().get(), 0) != 0) {
                return false;
            }
            previousHigh = current.getHigh();
        }
        return true;
    }

    private static TupleDomainFilter createBooleanFilter(List<Range> ranges, boolean nullAllowed) {
        boolean includesTrue = false;
        boolean includesFalse = false;
        for (Range range : ranges) {
            if (range.includes(Marker.exactly((Type)BooleanType.BOOLEAN, (Object)true))) {
                includesTrue = true;
            }
            if (!range.includes(Marker.exactly((Type)BooleanType.BOOLEAN, (Object)false))) continue;
            includesFalse = true;
        }
        if (includesTrue && includesFalse) {
            Preconditions.checkArgument((!nullAllowed ? 1 : 0) != 0, (Object)"Unexpected range of ALL values");
            return TupleDomainFilter.IS_NOT_NULL;
        }
        return TupleDomainFilter.BooleanValue.of(includesTrue, nullAllowed);
    }

    private static TupleDomainFilter createRangeFilter(Type type, Range range, boolean nullAllowed) {
        if (range.isAll()) {
            Preconditions.checkArgument((!nullAllowed ? 1 : 0) != 0, (Object)"Unexpected range of ALL values");
            return TupleDomainFilter.IS_NOT_NULL;
        }
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT || type == TimestampType.TIMESTAMP || type == DateType.DATE) {
            return TupleDomainFilterUtils.bigintRangeToFilter(range, nullAllowed);
        }
        if (type == BooleanType.BOOLEAN) {
            Preconditions.checkArgument((boolean)range.isSingleValue(), (Object)"Unexpected range of boolean values");
            return TupleDomainFilter.BooleanValue.of((Boolean)range.getSingleValue(), nullAllowed);
        }
        if (type == DoubleType.DOUBLE) {
            return TupleDomainFilterUtils.doubleRangeToFilter(range, nullAllowed);
        }
        if (type == RealType.REAL) {
            return TupleDomainFilterUtils.floatRangeToFilter(range, nullAllowed);
        }
        if (type instanceof DecimalType) {
            if (((DecimalType)type).isShort()) {
                return TupleDomainFilterUtils.bigintRangeToFilter(range, nullAllowed);
            }
            return TupleDomainFilterUtils.longDecimalRangeToFilter(range, nullAllowed);
        }
        if (Varchars.isVarcharType((Type)type) || type instanceof CharType) {
            return TupleDomainFilterUtils.varcharRangeToFilter(range, nullAllowed);
        }
        throw new UnsupportedOperationException("Unsupported type: " + type.getDisplayName());
    }

    private static TupleDomainFilter bigintRangeToFilter(Range range, boolean nullAllowed) {
        long upperLong;
        Marker low = range.getLow();
        Marker high = range.getHigh();
        long lowerLong = low.isLowerUnbounded() ? Long.MIN_VALUE : (Long)low.getValue();
        long l = upperLong = high.isUpperUnbounded() ? Long.MAX_VALUE : (Long)high.getValue();
        if (!high.isUpperUnbounded() && high.getBound() == Marker.Bound.BELOW) {
            --upperLong;
        }
        if (!low.isLowerUnbounded() && low.getBound() == Marker.Bound.ABOVE) {
            ++lowerLong;
        }
        if (upperLong < lowerLong) {
            return TupleDomainFilter.ALWAYS_FALSE;
        }
        return TupleDomainFilter.BigintRange.of(lowerLong, upperLong, nullAllowed);
    }

    private static TupleDomainFilter doubleRangeToFilter(Range range, boolean nullAllowed) {
        double upperDouble;
        Marker low = range.getLow();
        Marker high = range.getHigh();
        double lowerDouble = low.isLowerUnbounded() ? Double.MIN_VALUE : (Double)low.getValue();
        double d = upperDouble = high.isUpperUnbounded() ? Double.MAX_VALUE : (Double)high.getValue();
        if (!low.isLowerUnbounded() && Double.isNaN(lowerDouble)) {
            return TupleDomainFilter.ALWAYS_FALSE;
        }
        if (!high.isUpperUnbounded() && Double.isNaN(upperDouble)) {
            return TupleDomainFilter.ALWAYS_FALSE;
        }
        return TupleDomainFilter.DoubleRange.of(lowerDouble, low.isLowerUnbounded(), low.getBound() == Marker.Bound.ABOVE, upperDouble, high.isUpperUnbounded(), high.getBound() == Marker.Bound.BELOW, nullAllowed);
    }

    private static TupleDomainFilter floatRangeToFilter(Range range, boolean nullAllowed) {
        float upperFloat;
        Marker low = range.getLow();
        Marker high = range.getHigh();
        float lowerFloat = low.isLowerUnbounded() ? Float.MIN_VALUE : Float.intBitsToFloat(Math.toIntExact((Long)low.getValue()));
        float f = upperFloat = high.isUpperUnbounded() ? Float.MAX_VALUE : Float.intBitsToFloat(Math.toIntExact((Long)high.getValue()));
        if (!low.isLowerUnbounded() && Float.isNaN(lowerFloat)) {
            return TupleDomainFilter.ALWAYS_FALSE;
        }
        if (!high.isUpperUnbounded() && Float.isNaN(upperFloat)) {
            return TupleDomainFilter.ALWAYS_FALSE;
        }
        return TupleDomainFilter.FloatRange.of(lowerFloat, low.isLowerUnbounded(), low.getBound() == Marker.Bound.ABOVE, upperFloat, high.isUpperUnbounded(), high.getBound() == Marker.Bound.BELOW, nullAllowed);
    }

    private static TupleDomainFilter longDecimalRangeToFilter(Range range, boolean nullAllowed) {
        Marker low = range.getLow();
        Marker high = range.getHigh();
        return TupleDomainFilter.LongDecimalRange.of(low.isLowerUnbounded() ? Long.MIN_VALUE : ((Slice)low.getValue()).getLong(0), low.isLowerUnbounded() ? Long.MIN_VALUE : ((Slice)low.getValue()).getLong(8), low.isLowerUnbounded(), low.getBound() == Marker.Bound.ABOVE, high.isUpperUnbounded() ? Long.MAX_VALUE : ((Slice)high.getValue()).getLong(0), high.isUpperUnbounded() ? Long.MAX_VALUE : ((Slice)high.getValue()).getLong(8), high.isUpperUnbounded(), high.getBound() == Marker.Bound.BELOW, nullAllowed);
    }

    private static TupleDomainFilter varcharRangeToFilter(Range range, boolean nullAllowed) {
        Marker low = range.getLow();
        Marker high = range.getHigh();
        Slice lowerValue = low.isLowerUnbounded() ? null : (Slice)low.getValue();
        Slice upperValue = high.isUpperUnbounded() ? null : (Slice)high.getValue();
        return TupleDomainFilter.BytesRange.of(lowerValue == null ? null : lowerValue.getBytes(), low.getBound() == Marker.Bound.ABOVE, upperValue == null ? null : upperValue.getBytes(), high.getBound() == Marker.Bound.BELOW, nullAllowed);
    }

    public static TupleDomainFilter toBigintValues(long[] values, boolean nullAllowed) {
        long min = values[0];
        long max = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
            max = Math.max(max, values[i]);
        }
        BigInteger range = BigInteger.valueOf(max).subtract(BigInteger.valueOf(min)).add(BigInteger.valueOf(1L));
        if (range.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1 || range.intValueExact() / values.length > 192) {
            return TupleDomainFilter.BigintValuesUsingHashTable.of(min, max, values, nullAllowed);
        }
        return TupleDomainFilter.BigintValuesUsingBitmask.of(min, max, values, nullAllowed);
    }
}

