/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.ByteStreamCheckpoint;
import com.facebook.presto.orc.stream.ByteOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class BooleanOutputStream
implements ValueOutputStream<BooleanStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanOutputStream.class).instanceSize();
    private final ByteOutputStream byteOutputStream;
    private final List<Integer> checkpointBitOffsets = new ArrayList<Integer>();
    private int bitsInData;
    private int data;
    private boolean closed;

    public BooleanOutputStream(ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor) {
        this(new ByteOutputStream(columnWriterOptions, dwrfEncryptor));
    }

    public BooleanOutputStream(OrcOutputBuffer buffer) {
        this(new ByteOutputStream(buffer));
    }

    public BooleanOutputStream(ByteOutputStream byteOutputStream) {
        this.byteOutputStream = byteOutputStream;
    }

    public void writeBoolean(boolean value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (value) {
            this.data |= 1 << 7 - this.bitsInData;
        }
        ++this.bitsInData;
        if (this.bitsInData == 8) {
            this.flushData();
        }
    }

    public void writeBooleans(int count, boolean value) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count is negative");
        if (count == 0) {
            return;
        }
        if (this.bitsInData != 0) {
            int bitsToWrite = Math.min(count, 8 - this.bitsInData);
            if (value) {
                this.data |= BooleanOutputStream.getLowBitMask(bitsToWrite) << 8 - this.bitsInData - bitsToWrite;
            }
            this.bitsInData += bitsToWrite;
            count -= bitsToWrite;
            if (this.bitsInData == 8) {
                this.flushData();
            } else {
                Verify.verify((count == 0 ? 1 : 0) != 0);
                return;
            }
        }
        Verify.verify((this.bitsInData == 0 ? 1 : 0) != 0);
        while (count >= 8) {
            if (value) {
                this.byteOutputStream.writeByte((byte)-1);
            } else {
                this.byteOutputStream.writeByte((byte)0);
            }
            count -= 8;
        }
        if (count > 0) {
            if (value) {
                this.data = BooleanOutputStream.getLowBitMask(count) << 8 - count;
            }
            this.bitsInData = count;
        }
    }

    private void flushData() {
        this.byteOutputStream.writeByte((byte)this.data);
        this.data = 0;
        this.bitsInData = 0;
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.byteOutputStream.recordCheckpoint();
        this.checkpointBitOffsets.add(this.bitsInData);
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.bitsInData > 0) {
            this.flushData();
        }
        this.byteOutputStream.close();
    }

    @Override
    public List<BooleanStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder booleanStreamCheckpoint = ImmutableList.builder();
        List<ByteStreamCheckpoint> byteStreamCheckpoints = this.byteOutputStream.getCheckpoints();
        for (int groupId = 0; groupId < this.checkpointBitOffsets.size(); ++groupId) {
            int checkpointBitOffset = this.checkpointBitOffsets.get(groupId);
            ByteStreamCheckpoint byteStreamCheckpoint = byteStreamCheckpoints.get(groupId);
            booleanStreamCheckpoint.add((Object)new BooleanStreamCheckpoint(checkpointBitOffset, byteStreamCheckpoint));
        }
        return booleanStreamCheckpoint.build();
    }

    @Override
    public StreamDataOutput getStreamDataOutput(int column) {
        Preconditions.checkState((boolean)this.closed);
        return this.byteOutputStream.getStreamDataOutput(column);
    }

    @Override
    public long getBufferedBytes() {
        return this.byteOutputStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.byteOutputStream.getRetainedBytes();
    }

    @Override
    public void reset() {
        this.data = 0;
        this.bitsInData = 0;
        this.closed = false;
        this.byteOutputStream.reset();
        this.checkpointBitOffsets.clear();
    }

    private static int getLowBitMask(int bits) {
        return (1 << bits) - 1;
    }
}

