/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.DoubleStreamCheckpoint;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class DoubleOutputStream
implements ValueOutputStream<DoubleStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DoubleOutputStream.class).instanceSize();
    private final OrcOutputBuffer buffer;
    private final List<DoubleStreamCheckpoint> checkpoints = new ArrayList<DoubleStreamCheckpoint>();
    private boolean closed;

    public DoubleOutputStream(ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor) {
        this.buffer = new OrcOutputBuffer(columnWriterOptions, dwrfEncryptor);
    }

    public void writeDouble(double value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.buffer.writeDouble(value);
    }

    @Override
    public void close() {
        this.closed = true;
        this.buffer.close();
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new DoubleStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public List<DoubleStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(int column) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(column, Stream.StreamKind.DATA, Math.toIntExact(this.buffer.getOutputDataSize()), false));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

