/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.google.common.base.Preconditions;
import java.io.IOException;

public interface LongInputStream
extends ValueInputStream<LongStreamCheckpoint> {
    public long next() throws IOException;

    public void next(long[] var1, int var2) throws IOException;

    public void next(int[] var1, int var2) throws IOException;

    public void next(short[] var1, int var2) throws IOException;

    default public void nextIntVector(int items, int[] vector, int offset) throws IOException {
        Preconditions.checkPositionIndex((int)(items + offset), (int)vector.length);
        for (int i = offset; i < items + offset; ++i) {
            vector[i] = Math.toIntExact(this.next());
        }
    }

    default public void nextLongVector(int items, long[] vector) throws IOException {
        Preconditions.checkPositionIndex((int)items, (int)vector.length);
        for (int i = 0; i < items; ++i) {
            vector[i] = this.next();
        }
    }

    default public long sum(int items) throws IOException {
        long sum = 0L;
        for (int i = 0; i < items; ++i) {
            sum += this.next();
        }
        return sum;
    }
}

