/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.io.slice.Slice;
import org.apache.hadoop.hive.ql.io.slice.Slices;
import org.apache.hadoop.io.Text;

public final class DynamicByteArray {
    static final int DEFAULT_SIZE = 32768;
    private Slice data;
    private int length = 0;

    public DynamicByteArray() {
        this(32768);
    }

    public DynamicByteArray(int size) {
        if (size == 0) {
            throw new IllegalArgumentException("bad chunksize");
        }
        this.data = Slices.allocate((int)size);
    }

    private void grow(int index) {
        if (index >= this.data.length()) {
            int newSize = Math.max(index + 32768, 2 * this.data.length());
            Slice newSlice = Slices.allocate((int)newSize);
            newSlice.setBytes(0, this.data);
            this.data = newSlice;
        }
    }

    public byte get(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of 0.." + (this.length - 1));
        }
        return this.data.getByte(index);
    }

    public void set(int index, byte value) {
        this.grow(index);
        if (index >= this.length) {
            this.length = index + 1;
        }
        this.data.setByte(index, (int)value);
    }

    public int add(byte value) {
        this.grow(this.length);
        this.data.setByte(this.length, (int)value);
        int result = this.length++;
        return result;
    }

    public int add(byte[] value, int valueOffset, int valueLength) {
        this.grow(this.length + valueLength);
        this.data.setBytes(this.length, value, valueOffset, valueLength);
        int result = this.length;
        this.length += valueLength;
        return result;
    }

    public void readAll(InputStream in) throws IOException {
        int read = 0;
        do {
            this.grow(this.length);
            read = this.data.setBytes(this.length, in, this.data.length() - this.length);
            if (read <= 0) continue;
            this.length += read;
        } while (in.available() > 0);
    }

    public void read(InputStream in, int lengthToRead) throws IOException {
        int read = 0;
        do {
            this.grow(this.length);
            read = this.data.setBytes(this.length, in, Math.min(lengthToRead, this.data.length() - this.length));
            this.length += read;
        } while ((lengthToRead -= read) > 0);
    }

    public int compare(byte[] other, int otherOffset, int otherLength, int ourOffset, int ourLength) {
        return 0 - this.data.compareTo(ourOffset, ourLength, other, otherOffset, otherLength);
    }

    public int compare(int otherOffset, int otherLength, int ourOffset, int ourLength) {
        return 0 - this.data.compareTo(ourOffset, ourLength, this.data, otherOffset, otherLength);
    }

    public boolean equals(byte[] other, int otherOffset, int otherLength, int ourOffset, int ourLength) {
        return this.data.equals(ourOffset, ourLength, other, otherOffset, otherLength);
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        this.length = 0;
        this.data = Slices.allocate((int)32768);
    }

    public void setText(Text result, int offset, int length) {
        result.clear();
        result.set(this.data.getBytes(), offset, length);
    }

    public void write(OutputStream out, int offset, int length) throws IOException {
        this.data.getBytes(offset, out, length);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(this.length * 3);
        sb.append('{');
        int l = this.length - 1;
        for (i = 0; i < l; ++i) {
            sb.append(Integer.toHexString(this.get(i)));
            sb.append(',');
        }
        sb.append(this.get(i));
        sb.append('}');
        return sb.toString();
    }

    public void setByteBuffer(ByteBuffer result, int offset, int length) {
        result.clear();
        result.put(this.data.getBytes(), offset, length);
    }

    public long getSizeInBytes() {
        return this.data.length();
    }
}

