/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RunLengthIntegerReader;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Text;

class LazyStringDirectTreeReader
extends LazyTreeReader {
    private InStream stream;
    private RunLengthIntegerReader lengths;

    LazyStringDirectTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
        this.stream = streams.get(name);
        this.lengths = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, 4);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.stream.seek(index);
        this.lengths.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        updatedStartIndex = this.stream.loadIndeces(rowIndexEntries, updatedStartIndex);
        return this.lengths.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    @Override
    public Object next(Object previous) throws IOException {
        Text result = null;
        if (this.valuePresent) {
            result = previous == null ? new Text() : (Text)previous;
            int len = (int)this.lengths.next();
            int offset = 0;
            byte[] bytes = new byte[len];
            while (len > 0) {
                int written = this.stream.read(bytes, offset, len);
                if (written < 0) {
                    throw new EOFException("Can't finish byte read from " + this.stream);
                }
                len -= written;
                offset += written;
            }
            result.set(bytes);
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        long lengthToSkip = 0L;
        int i = 0;
        while ((long)i < numNonNullValues) {
            lengthToSkip += this.lengths.next();
            ++i;
        }
        this.stream.skip(lengthToSkip);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.lengths != null) {
            this.lengths.close();
        }
    }
}

