/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.discovery.client.ServiceState;
import io.airlift.node.NodeInfo;
import java.util.Map;
import java.util.UUID;

public class ServiceDescriptor {
    private final UUID id;
    private final String nodeId;
    private final String type;
    private final String pool;
    private final String location;
    private final ServiceState state;
    private final Map<String, String> properties;

    @JsonCreator
    public ServiceDescriptor(@JsonProperty(value="id") UUID id, @JsonProperty(value="nodeId") String nodeId, @JsonProperty(value="type") String type, @JsonProperty(value="pool") String pool, @JsonProperty(value="location") String location, @JsonProperty(value="state") ServiceState state, @JsonProperty(value="properties") Map<String, String> properties) {
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        this.id = id;
        this.nodeId = nodeId;
        this.type = type;
        this.pool = pool;
        this.location = location;
        this.state = state;
        this.properties = ImmutableMap.copyOf(properties);
    }

    @JsonProperty
    public UUID getId() {
        return this.id;
    }

    @JsonProperty
    public String getNodeId() {
        return this.nodeId;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public String getPool() {
        return this.pool;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public ServiceState getState() {
        return this.state;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDescriptor that = (ServiceDescriptor)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("nodeId", (Object)this.nodeId).add("type", (Object)this.type).add("pool", (Object)this.pool).add("location", (Object)this.location).add("state", (Object)this.state).add("properties", this.properties).toString();
    }

    public static ServiceDescriptorBuilder serviceDescriptor(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        return new ServiceDescriptorBuilder(type);
    }

    public static class ServiceDescriptorBuilder {
        private UUID id = UUID.randomUUID();
        private String nodeId;
        private final String type;
        private String pool = "general";
        private String location;
        private ServiceState state;
        private final ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private ServiceDescriptorBuilder(String type) {
            this.type = type;
        }

        public ServiceDescriptorBuilder setId(UUID id) {
            Preconditions.checkNotNull((Object)id, (Object)"id is null");
            this.id = id;
            return this;
        }

        public ServiceDescriptorBuilder setNodeInfo(NodeInfo nodeInfo) {
            Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
            this.nodeId = nodeInfo.getNodeId();
            this.pool = nodeInfo.getPool();
            return this;
        }

        public ServiceDescriptorBuilder setNodeId(String nodeId) {
            Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId is null");
            this.nodeId = nodeId;
            return this;
        }

        public ServiceDescriptorBuilder setPool(String pool) {
            Preconditions.checkNotNull((Object)pool, (Object)"pool is null");
            this.pool = pool;
            return this;
        }

        public ServiceDescriptorBuilder setLocation(String location) {
            Preconditions.checkNotNull((Object)location, (Object)"location is null");
            this.location = location;
            return this;
        }

        public ServiceDescriptorBuilder setState(ServiceState state) {
            Preconditions.checkNotNull((Object)((Object)state), (Object)"state is null");
            this.state = state;
            return this;
        }

        public ServiceDescriptorBuilder addProperty(String key, String value) {
            Preconditions.checkNotNull((Object)key, (Object)"key is null");
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        public ServiceDescriptorBuilder addProperties(Map<String, String> properties) {
            Preconditions.checkNotNull(properties, (Object)"properties is null");
            this.properties.putAll(properties);
            return this;
        }

        public ServiceDescriptor build() {
            return new ServiceDescriptor(this.id, this.nodeId, this.type, this.pool, this.location, this.state, (Map<String, String>)this.properties.build());
        }
    }
}

