/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client.testing;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.discovery.client.ServiceSelectorFactory;
import io.airlift.discovery.client.testing.SimpleServiceSelector;

public class SimpleServiceSelectorFactory
implements ServiceSelectorFactory {
    private final DiscoveryLookupClient lookupClient;

    @Inject
    public SimpleServiceSelectorFactory(DiscoveryLookupClient lookupClient) {
        Preconditions.checkNotNull((Object)lookupClient, (Object)"client is null");
        this.lookupClient = lookupClient;
    }

    @Override
    public ServiceSelector createServiceSelector(String type, ServiceSelectorConfig selectorConfig) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)selectorConfig, (Object)"selectorConfig is null");
        return new SimpleServiceSelector(type, selectorConfig, this.lookupClient);
    }
}

