/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.airlift.json.ObjectMapperProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JsonCodec<T> {
    private static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = Suppliers.memoize((Supplier)new Supplier<ObjectMapper>(){

        public ObjectMapper get() {
            return new ObjectMapperProvider().get().enable(SerializationFeature.INDENT_OUTPUT);
        }
    });
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> JsonCodec<T> jsonCodec(Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new JsonCodec<T>((ObjectMapper)OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    public static <T> JsonCodec<T> jsonCodec(TypeToken<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new JsonCodec<T>((ObjectMapper)OBJECT_MAPPER_SUPPLIER.get(), type.getType());
    }

    public static <T> JsonCodec<List<T>> listJsonCodec(Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
        return new JsonCodec<List<T>>((ObjectMapper)OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <T> JsonCodec<List<T>> listJsonCodec(JsonCodec<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type.getTypeToken()).getType();
        return new JsonCodec<List<T>>((ObjectMapper)OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, Class<V> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
        return new JsonCodec<Map<K, V>>((ObjectMapper)OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    public static <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, JsonCodec<V> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType.getTypeToken()).getType();
        return new JsonCodec<Map<K, V>>((ObjectMapper)OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    JsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = mapper;
        this.type = type;
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public Type getType() {
        return this.type;
    }

    public T fromJson(String json) throws IllegalArgumentException {
        try {
            return (T)this.mapper.readValue(json, this.javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid %s json string", this.javaType), e);
        }
    }

    public String toJson(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writeValueAsString(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to json", instance.getClass().getName()), e);
        }
    }

    public T fromJson(byte[] json) throws IllegalArgumentException {
        try {
            return (T)this.mapper.readValue(json, this.javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid %s json bytes", this.javaType), e);
        }
    }

    public byte[] toJsonBytes(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writeValueAsBytes(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to json", instance.getClass().getName()), e);
        }
    }

    TypeToken<T> getTypeToken() {
        return TypeToken.of((Type)this.type);
    }
}

