/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;

public class CorruptFileBlockIterator
implements RemoteIterator<Path> {
    private final DFSClient dfs;
    private String path;
    private String[] files = null;
    private int fileIdx = 0;
    private String cookie = null;
    private Path nextPath = null;
    private int callsMade = 0;

    public CorruptFileBlockIterator(DFSClient dfs, Path path) throws IOException {
        this.dfs = dfs;
        this.path = this.path2String(path);
        this.loadNext();
    }

    public int getCallsMade() {
        return this.callsMade;
    }

    private String path2String(Path path) {
        return path.toUri().getPath();
    }

    private Path string2Path(String string) {
        return new Path(string);
    }

    private void loadNext() throws IOException {
        if (this.files == null || this.fileIdx >= this.files.length) {
            CorruptFileBlocks cfb = this.dfs.listCorruptFileBlocks(this.path, this.cookie);
            this.files = cfb.getFiles();
            this.cookie = cfb.getCookie();
            this.fileIdx = 0;
            ++this.callsMade;
        }
        if (this.fileIdx >= this.files.length) {
            this.nextPath = null;
        } else {
            this.nextPath = this.string2Path(this.files[this.fileIdx]);
            ++this.fileIdx;
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextPath != null;
    }

    @Override
    public Path next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more corrupt file blocks");
        }
        Path result = this.nextPath;
        this.loadNext();
        return result;
    }
}

