/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class Util {
    private static final Log LOG = LogFactory.getLog(Util.class.getName());

    public static URI stringAsURI(String s) throws IOException {
        URI u = null;
        try {
            u = new URI(s);
        }
        catch (URISyntaxException e) {
            LOG.error("Syntax error in URI " + s + ". Please check hdfs configuration.", e);
        }
        if (u == null || u.getScheme() == null) {
            LOG.warn("Path " + s + " should be specified as a URI " + "in configuration files. Please update hdfs configuration.");
            u = Util.fileAsURI(new File(s));
        }
        return u;
    }

    public static URI fileAsURI(File f) throws IOException {
        URI u = f.getCanonicalFile().toURI();
        if (u.getPath().endsWith("/")) {
            String uriAsString = u.toString();
            try {
                u = new URI(uriAsString.substring(0, uriAsString.length() - 1));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return u;
    }

    public static List<URI> stringCollectionAsURIs(Collection<String> names) {
        ArrayList<URI> uris = new ArrayList<URI>(names.size());
        for (String name : names) {
            try {
                uris.add(Util.stringAsURI(name));
            }
            catch (IOException e) {
                LOG.error("Error while processing URI: " + name, e);
            }
        }
        return uris;
    }
}

