/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.util.HashMap;
import java.util.Map;

class NameCache<K> {
    static final Log LOG = LogFactory.getLog(NameCache.class.getName());
    private boolean initialized = false;
    private final int useThreshold;
    private int lookups = 0;
    final HashMap<K, K> cache = new HashMap();
    Map<K, UseCount> transientMap = new HashMap<K, UseCount>();

    NameCache(int useThreshold) {
        this.useThreshold = useThreshold;
    }

    K put(K name) {
        K internal = this.cache.get(name);
        if (internal != null) {
            ++this.lookups;
            return internal;
        }
        if (!this.initialized) {
            UseCount useCount = this.transientMap.get(name);
            if (useCount != null) {
                useCount.increment();
                if (useCount.get() >= this.useThreshold) {
                    this.promote(name);
                }
                return useCount.value;
            }
            useCount = new UseCount(name);
            this.transientMap.put(name, useCount);
        }
        return null;
    }

    int getLookupCount() {
        return this.lookups;
    }

    int size() {
        return this.cache.size();
    }

    void initialized() {
        LOG.info("initialized with " + this.size() + " entries " + this.lookups + " lookups");
        this.initialized = true;
        this.transientMap.clear();
        this.transientMap = null;
    }

    private void promote(K name) {
        this.transientMap.remove(name);
        this.cache.put(name, name);
        this.lookups += this.useThreshold;
    }

    public void reset() {
        this.initialized = false;
        this.cache.clear();
        if (this.transientMap == null) {
            this.transientMap = new HashMap<K, UseCount>();
        } else {
            this.transientMap.clear();
        }
    }

    private class UseCount {
        int count = 1;
        final K value;

        UseCount(K value) {
            this.value = value;
        }

        void increment() {
            ++this.count;
        }

        int get() {
            return this.count;
        }
    }
}

