/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import com.facebook.presto.hadoop.shaded.com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

public class INodeDirectoryWithSnapshot
extends INodeDirectoryWithQuota {
    private final DirectoryDiffList diffs;

    boolean computeDiffBetweenSnapshots(Snapshot fromSnapshot, Snapshot toSnapshot, ChildrenDiff diff) {
        int i;
        boolean modified;
        Snapshot earlier = fromSnapshot;
        Snapshot later = toSnapshot;
        if (Snapshot.ID_COMPARATOR.compare(fromSnapshot, toSnapshot) > 0) {
            earlier = toSnapshot;
            later = fromSnapshot;
        }
        if (!(modified = this.diffs.changedBetweenSnapshots(earlier, later))) {
            return false;
        }
        List difflist = this.diffs.asList();
        int size = difflist.size();
        int earlierDiffIndex = Collections.binarySearch(difflist, earlier.getId());
        int laterDiffIndex = later == null ? size : Collections.binarySearch(difflist, later.getId());
        earlierDiffIndex = earlierDiffIndex < 0 ? -earlierDiffIndex - 1 : earlierDiffIndex;
        laterDiffIndex = laterDiffIndex < 0 ? -laterDiffIndex - 1 : laterDiffIndex;
        boolean dirMetadataChanged = false;
        INodeDirectoryAttributes dirCopy = null;
        for (i = earlierDiffIndex; i < laterDiffIndex; ++i) {
            DirectoryDiff sdiff = (DirectoryDiff)difflist.get(i);
            diff.combinePosterior(sdiff.diff, null);
            if (dirMetadataChanged || sdiff.snapshotINode == null) continue;
            if (dirCopy == null) {
                dirCopy = (INodeDirectoryAttributes)sdiff.snapshotINode;
                continue;
            }
            if (dirCopy.metadataEquals((INodeDirectoryAttributes)sdiff.snapshotINode)) continue;
            dirMetadataChanged = true;
        }
        if (!diff.isEmpty() || dirMetadataChanged) {
            return true;
        }
        if (dirCopy != null) {
            for (i = laterDiffIndex; i < size; ++i) {
                if (dirCopy.metadataEquals((INodeDirectoryAttributes)((DirectoryDiff)difflist.get((int)i)).snapshotINode)) continue;
                return true;
            }
            return !dirCopy.metadataEquals(this);
        }
        return false;
    }

    public INodeDirectoryWithSnapshot(INodeDirectory that) {
        this(that, true, that instanceof INodeDirectoryWithSnapshot ? ((INodeDirectoryWithSnapshot)that).getDiffs() : null);
    }

    INodeDirectoryWithSnapshot(INodeDirectory that, boolean adopt, DirectoryDiffList diffs) {
        super(that, adopt, that.getNsQuota(), that.getDsQuota());
        this.diffs = diffs != null ? diffs : new DirectoryDiffList();
    }

    public Snapshot getLastSnapshot() {
        return this.diffs.getLastSnapshot();
    }

    public DirectoryDiffList getDiffs() {
        return this.diffs;
    }

    @Override
    public INodeDirectoryAttributes getSnapshotINode(Snapshot snapshot) {
        return this.diffs.getSnapshotINode(snapshot, this);
    }

    @Override
    public INodeDirectoryWithSnapshot recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        if (this.isInLatestSnapshot(latest) && !this.shouldRecordInSrcSnapshot(latest)) {
            return this.saveSelf2Snapshot(latest, null);
        }
        return this;
    }

    public INodeDirectoryWithSnapshot saveSelf2Snapshot(Snapshot latest, INodeDirectory snapshotCopy) throws QuotaExceededException {
        this.diffs.saveSelf2Snapshot(latest, this, snapshotCopy);
        return this;
    }

    @Override
    public INode saveChild2Snapshot(INode child, Snapshot latest, INode snapshotCopy, INodeMap inodeMap) throws QuotaExceededException {
        Preconditions.checkArgument(!child.isDirectory(), "child is a directory, child=%s", child);
        if (latest == null) {
            return child;
        }
        DirectoryDiff diff = (DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latest, this);
        if (diff.getChild(child.getLocalNameBytes(), false, this) != null) {
            return child;
        }
        diff.diff.modify(snapshotCopy, child);
        return child;
    }

    @Override
    public boolean addChild(INode inode, boolean setModTime, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        boolean added;
        ChildrenDiff diff = null;
        Integer undoInfo = null;
        if (this.isInLatestSnapshot(latest)) {
            diff = ((DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latest, this)).diff;
            undoInfo = diff.create(inode);
        }
        if (!(added = super.addChild(inode, setModTime, null, inodeMap)) && undoInfo != null) {
            diff.undoCreate(inode, undoInfo);
        }
        return added;
    }

    @Override
    public boolean removeChild(INode child, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        ChildrenDiff diff = null;
        Diff.UndoInfo<INode> undoInfo = null;
        if (this.isInLatestSnapshot(latest)) {
            diff = ((DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latest, this)).diff;
            undoInfo = diff.delete(child);
        }
        boolean removed = this.removeChild(child);
        if (undoInfo != null && !removed) {
            diff.undoDelete(child, undoInfo);
        }
        return removed;
    }

    @Override
    public void replaceChild(INode oldChild, INode newChild, INodeMap inodeMap) {
        super.replaceChild(oldChild, newChild, inodeMap);
        this.diffs.replaceChild(Diff.ListType.CREATED, oldChild, newChild);
    }

    public void undoRename4ScrParent(INodeReference oldChild, INode newChild, Snapshot latestSnapshot) throws QuotaExceededException {
        this.diffs.removeChild(Diff.ListType.DELETED, oldChild);
        this.diffs.replaceChild(Diff.ListType.CREATED, oldChild, newChild);
        this.addChild(newChild, true, null, null);
    }

    public void undoRename4DstParent(INode deletedChild, Snapshot latestSnapshot) throws QuotaExceededException {
        boolean removeDeletedChild = this.diffs.removeChild(Diff.ListType.DELETED, deletedChild);
        boolean added = this.addChild(deletedChild, true, removeDeletedChild ? null : latestSnapshot, null);
        if (added && !removeDeletedChild) {
            Quota.Counts counts = deletedChild.computeQuotaUsage();
            this.addSpaceConsumed(counts.get(Quota.NAMESPACE), counts.get(Quota.DISKSPACE), false);
        }
    }

    @Override
    public ReadOnlyList<INode> getChildrenList(Snapshot snapshot) {
        DirectoryDiff diff = (DirectoryDiff)this.diffs.getDiff(snapshot);
        return diff != null ? diff.getChildrenList(this) : super.getChildrenList(null);
    }

    @Override
    public INode getChild(byte[] name, Snapshot snapshot) {
        DirectoryDiff diff = (DirectoryDiff)this.diffs.getDiff(snapshot);
        return diff != null ? diff.getChild(name, true, this) : super.getChild(name, null);
    }

    @Override
    public String toDetailString() {
        return super.toDetailString() + ", " + this.diffs;
    }

    public void getSnapshotDirectory(List<INodeDirectory> snapshotDir) {
        for (DirectoryDiff sdiff : this.diffs) {
            sdiff.getChildrenDiff().getDirsInDeleted(snapshotDir);
        }
    }

    @Override
    public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
        Quota.Counts counts = Quota.Counts.newInstance();
        HashMap<INode, INode> priorCreated = null;
        HashMap<INode, INode> priorDeleted = null;
        if (snapshot == null) {
            this.recordModification(prior, null);
            DirectoryDiff lastDiff = (DirectoryDiff)this.diffs.getLast();
            if (lastDiff != null) {
                counts.add(lastDiff.diff.destroyCreatedList(this, collectedBlocks, removedINodes));
            }
        } else {
            DirectoryDiff priorDiff;
            prior = this.getDiffs().updatePrior(snapshot, prior);
            if (prior != null && (priorDiff = (DirectoryDiff)this.getDiffs().getDiff(prior)) != null && priorDiff.getSnapshot().equals(prior)) {
                List cList = priorDiff.diff.getList(Diff.ListType.CREATED);
                List dList = priorDiff.diff.getList(Diff.ListType.DELETED);
                priorCreated = new HashMap<INode, INode>(cList.size());
                for (INode cNode : cList) {
                    priorCreated.put(cNode, cNode);
                }
                priorDeleted = new HashMap<INode, INode>(dList.size());
                for (INode dNode : dList) {
                    priorDeleted.put(dNode, dNode);
                }
            }
            counts.add(this.getDiffs().deleteSnapshotDiff(snapshot, prior, this, collectedBlocks, removedINodes, countDiffChange));
            if (prior != null && (priorDiff = (DirectoryDiff)this.getDiffs().getDiff(prior)) != null && priorDiff.getSnapshot().equals(prior)) {
                if (priorCreated != null) {
                    for (INode cNode : priorDiff.getChildrenDiff().getList(Diff.ListType.CREATED)) {
                        if (!priorCreated.containsKey(cNode)) continue;
                        counts.add(cNode.cleanSubtree(snapshot, null, collectedBlocks, removedINodes, countDiffChange));
                    }
                }
                for (INode dNode : priorDiff.getChildrenDiff().getList(Diff.ListType.DELETED)) {
                    if (priorDeleted != null && priorDeleted.containsKey(dNode)) continue;
                    counts.add(INodeDirectoryWithSnapshot.cleanDeletedINode(dNode, snapshot, prior, collectedBlocks, removedINodes, countDiffChange));
                }
            }
        }
        counts.add(this.cleanSubtreeRecursively(snapshot, prior, collectedBlocks, removedINodes, priorDeleted, countDiffChange));
        if (this.isQuotaSet()) {
            this.addSpaceConsumed2Cache(-counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
        }
        return counts;
    }

    private static Quota.Counts cleanDeletedINode(INode inode, Snapshot post, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
        Quota.Counts counts = Quota.Counts.newInstance();
        ArrayDeque<INode> queue = new ArrayDeque<INode>();
        queue.addLast(inode);
        while (!queue.isEmpty()) {
            INodeDirectoryWithSnapshot sdir;
            DirectoryDiff priorDiff;
            INode topNode = (INode)queue.pollFirst();
            if (topNode instanceof INodeReference.WithName) {
                INodeReference.WithName wn = (INodeReference.WithName)topNode;
                if (wn.getLastSnapshotId() < post.getId()) continue;
                wn.cleanSubtree(post, prior, collectedBlocks, removedINodes, countDiffChange);
                continue;
            }
            if (topNode.isFile() && topNode.asFile() instanceof FileWithSnapshot) {
                FileWithSnapshot fs = (FileWithSnapshot)((Object)topNode.asFile());
                counts.add(fs.getDiffs().deleteSnapshotDiff(post, prior, topNode.asFile(), collectedBlocks, removedINodes, countDiffChange));
                continue;
            }
            if (!topNode.isDirectory()) continue;
            INodeDirectory dir = topNode.asDirectory();
            ChildrenDiff priorChildrenDiff = null;
            if (dir instanceof INodeDirectoryWithSnapshot && (priorDiff = (DirectoryDiff)(sdir = (INodeDirectoryWithSnapshot)dir).getDiffs().getDiff(prior)) != null && priorDiff.getSnapshot().equals(prior)) {
                priorChildrenDiff = priorDiff.getChildrenDiff();
                counts.add(priorChildrenDiff.destroyCreatedList(sdir, collectedBlocks, removedINodes));
            }
            for (INode child : dir.getChildrenList(prior)) {
                if (priorChildrenDiff != null && priorChildrenDiff.search(Diff.ListType.DELETED, child.getLocalNameBytes()) != null) continue;
                queue.addLast(child);
            }
        }
        return counts;
    }

    @Override
    public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        for (DirectoryDiff diff : this.diffs) {
            diff.destroyDiffAndCollectBlocks(this, collectedBlocks, removedINodes);
        }
        this.diffs.clear();
        super.destroyAndCollectBlocks(collectedBlocks, removedINodes);
    }

    @Override
    public final Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
        if (useCache && this.isQuotaSet() || lastSnapshotId == -1) {
            return super.computeQuotaUsage(counts, useCache, lastSnapshotId);
        }
        Snapshot lastSnapshot = this.diffs.getSnapshotById(lastSnapshotId);
        ReadOnlyList<INode> childrenList = this.getChildrenList(lastSnapshot);
        for (INode child : childrenList) {
            child.computeQuotaUsage(counts, useCache, lastSnapshotId);
        }
        counts.add(Quota.NAMESPACE, 1L);
        return counts;
    }

    @Override
    public Quota.Counts computeQuotaUsage4CurrentDirectory(Quota.Counts counts) {
        super.computeQuotaUsage4CurrentDirectory(counts);
        for (DirectoryDiff d : this.diffs) {
            for (INode deleted : d.getChildrenDiff().getList(Diff.ListType.DELETED)) {
                deleted.computeQuotaUsage(counts, false, -1);
            }
        }
        counts.add(Quota.NAMESPACE, this.diffs.asList().size());
        return counts;
    }

    @Override
    public Content.Counts computeContentSummary(Content.Counts counts) {
        super.computeContentSummary(counts);
        this.computeContentSummary4Snapshot(counts);
        return counts;
    }

    private void computeContentSummary4Snapshot(Content.Counts counts) {
        for (DirectoryDiff d : this.diffs) {
            for (INode deleted : d.getChildrenDiff().getList(Diff.ListType.DELETED)) {
                deleted.computeContentSummary(counts);
            }
        }
        counts.add(Content.DIRECTORY, this.diffs.asList().size());
    }

    public static void destroyDstSubtree(INode inode, Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws QuotaExceededException {
        Preconditions.checkArgument(prior != null);
        if (inode.isReference()) {
            if (inode instanceof INodeReference.WithName && snapshot != null) {
                inode.cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, true);
            } else {
                INodeDirectoryWithSnapshot.destroyDstSubtree(inode.asReference().getReferredINode(), snapshot, prior, collectedBlocks, removedINodes);
            }
        } else if (inode.isFile() && snapshot != null) {
            inode.cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, true);
        } else if (inode.isDirectory()) {
            HashMap<INode, INode> excludedNodes = null;
            if (inode instanceof INodeDirectoryWithSnapshot) {
                DirectoryDiff priorDiff;
                INodeDirectoryWithSnapshot sdir = (INodeDirectoryWithSnapshot)inode;
                DirectoryDiffList diffList = sdir.getDiffs();
                if (snapshot != null) {
                    diffList.deleteSnapshotDiff(snapshot, prior, sdir, collectedBlocks, removedINodes, true);
                }
                if ((priorDiff = (DirectoryDiff)diffList.getDiff(prior)) != null && priorDiff.getSnapshot().equals(prior)) {
                    priorDiff.diff.destroyCreatedList(sdir, collectedBlocks, removedINodes);
                    List dList = priorDiff.diff.getList(Diff.ListType.DELETED);
                    excludedNodes = new HashMap<INode, INode>(dList.size());
                    for (INode dNode : dList) {
                        excludedNodes.put(dNode, dNode);
                    }
                }
            }
            for (INode child : inode.asDirectory().getChildrenList(prior)) {
                if (excludedNodes != null && excludedNodes.containsKey(child)) continue;
                INodeDirectoryWithSnapshot.destroyDstSubtree(child, snapshot, prior, collectedBlocks, removedINodes);
            }
        }
    }

    public static class DirectoryDiffList
    extends AbstractINodeDiffList<INodeDirectory, INodeDirectoryAttributes, DirectoryDiff> {
        @Override
        DirectoryDiff createDiff(Snapshot snapshot, INodeDirectory currentDir) {
            return new DirectoryDiff(snapshot, currentDir);
        }

        @Override
        INodeDirectoryAttributes createSnapshotCopy(INodeDirectory currentDir) {
            return currentDir.isQuotaSet() ? new INodeDirectoryAttributes.CopyWithQuota(currentDir) : new INodeDirectoryAttributes.SnapshotCopy(currentDir);
        }

        private boolean replaceChild(Diff.ListType type, INode oldChild, INode newChild) {
            List diffList = this.asList();
            for (int i = diffList.size() - 1; i >= 0; --i) {
                ChildrenDiff diff = ((DirectoryDiff)diffList.get(i)).diff;
                if (!diff.replace(type, oldChild, newChild)) continue;
                return true;
            }
            return false;
        }

        private boolean removeChild(Diff.ListType type, INode child) {
            List diffList = this.asList();
            for (int i = diffList.size() - 1; i >= 0; --i) {
                ChildrenDiff diff = ((DirectoryDiff)diffList.get(i)).diff;
                if (!diff.removeChild(type, child)) continue;
                return true;
            }
            return false;
        }
    }

    public static class DirectoryDiff
    extends AbstractINodeDiff<INodeDirectory, INodeDirectoryAttributes, DirectoryDiff> {
        private final int childrenSize;
        private final ChildrenDiff diff;

        private DirectoryDiff(Snapshot snapshot, INodeDirectory dir) {
            super(snapshot, null, null);
            this.childrenSize = dir.getChildrenList(null).size();
            this.diff = new ChildrenDiff();
        }

        DirectoryDiff(Snapshot snapshot, INodeDirectoryAttributes snapshotINode, DirectoryDiff posteriorDiff, int childrenSize, List<INode> createdList, List<INode> deletedList) {
            super(snapshot, snapshotINode, posteriorDiff);
            this.childrenSize = childrenSize;
            this.diff = new ChildrenDiff(createdList, deletedList);
        }

        ChildrenDiff getChildrenDiff() {
            return this.diff;
        }

        boolean isSnapshotRoot() {
            return this.snapshotINode == this.snapshot.getRoot();
        }

        @Override
        Quota.Counts combinePosteriorAndCollectBlocks(INodeDirectory currentDir, DirectoryDiff posterior, final INode.BlocksMapUpdateInfo collectedBlocks, final List<INode> removedINodes) {
            final Quota.Counts counts = Quota.Counts.newInstance();
            this.diff.combinePosterior(posterior.diff, new Diff.Processor<INode>(){

                @Override
                public void process(INode inode) {
                    if (inode != null) {
                        inode.computeQuotaUsage(counts, false);
                        inode.destroyAndCollectBlocks(collectedBlocks, removedINodes);
                    }
                }
            });
            return counts;
        }

        ReadOnlyList<INode> getChildrenList(final INodeDirectory currentDir) {
            return new ReadOnlyList<INode>(){
                private List<INode> children = null;

                private List<INode> initChildren() {
                    if (this.children == null) {
                        ChildrenDiff combined = new ChildrenDiff();
                        for (DirectoryDiff d = DirectoryDiff.this; d != null; d = (DirectoryDiff)d.getPosterior()) {
                            combined.combinePosterior(d.diff, null);
                        }
                        this.children = combined.apply2Current(ReadOnlyList.Util.asList(currentDir.getChildrenList(null)));
                    }
                    return this.children;
                }

                @Override
                public Iterator<INode> iterator() {
                    return this.initChildren().iterator();
                }

                @Override
                public boolean isEmpty() {
                    return DirectoryDiff.this.childrenSize == 0;
                }

                @Override
                public int size() {
                    return DirectoryDiff.this.childrenSize;
                }

                @Override
                public INode get(int i) {
                    return this.initChildren().get(i);
                }
            };
        }

        INode getChild(byte[] name, boolean checkPosterior, INodeDirectory currentDir) {
            DirectoryDiff d = this;
            Diff.Container returned;
            while ((returned = d.diff.accessPrevious(name)) == null) {
                if (!checkPosterior) {
                    return null;
                }
                if (d.getPosterior() == null) {
                    return currentDir.getChild(name, null);
                }
                d = (DirectoryDiff)d.getPosterior();
            }
            return (INode)returned.getElement();
        }

        @Override
        public String toString() {
            return super.toString() + " childrenSize=" + this.childrenSize + ", " + this.diff;
        }

        @Override
        void write(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            this.writeSnapshot(out);
            out.writeInt(this.childrenSize);
            if (this.isSnapshotRoot()) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                if (this.snapshotINode != null) {
                    out.writeBoolean(true);
                    FSImageSerialization.writeINodeDirectoryAttributes((INodeDirectoryAttributes)this.snapshotINode, out);
                } else {
                    out.writeBoolean(false);
                }
            }
            this.diff.write(out, referenceMap);
        }

        @Override
        Quota.Counts destroyDiffAndCollectBlocks(INodeDirectory currentINode, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            Quota.Counts counts = Quota.Counts.newInstance();
            counts.add(this.diff.destroyDeletedList(collectedBlocks, removedINodes));
            return counts;
        }
    }

    static class ChildrenDiff
    extends Diff<byte[], INode> {
        ChildrenDiff() {
        }

        private ChildrenDiff(List<INode> created, List<INode> deleted) {
            super(created, deleted);
        }

        private final boolean replace(Diff.ListType type, INode oldChild, INode newChild) {
            List<INode> list = this.getList(type);
            int i = ChildrenDiff.search(list, oldChild.getLocalNameBytes());
            if (i < 0) {
                return false;
            }
            INode removed = list.set(i, newChild);
            Preconditions.checkState(removed == oldChild);
            return true;
        }

        private final boolean removeChild(Diff.ListType type, INode child) {
            List list = this.getList(type);
            int i = this.searchIndex(type, child.getLocalNameBytes());
            if (i >= 0 && list.get(i) == child) {
                list.remove(i);
                return true;
            }
            return false;
        }

        private Quota.Counts destroyCreatedList(INodeDirectoryWithSnapshot currentINode, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            Quota.Counts counts = Quota.Counts.newInstance();
            List createdList = this.getList(Diff.ListType.CREATED);
            for (INode c : createdList) {
                c.computeQuotaUsage(counts, true);
                c.destroyAndCollectBlocks(collectedBlocks, removedINodes);
                currentINode.removeChild(c);
            }
            createdList.clear();
            return counts;
        }

        private Quota.Counts destroyDeletedList(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            Quota.Counts counts = Quota.Counts.newInstance();
            List deletedList = this.getList(Diff.ListType.DELETED);
            for (INode d : deletedList) {
                d.computeQuotaUsage(counts, false);
                d.destroyAndCollectBlocks(collectedBlocks, removedINodes);
            }
            deletedList.clear();
            return counts;
        }

        private void writeCreated(DataOutput out) throws IOException {
            List created = this.getList(Diff.ListType.CREATED);
            out.writeInt(created.size());
            for (INode node : created) {
                byte[] name = node.getLocalNameBytes();
                out.writeShort(name.length);
                out.write(name);
            }
        }

        private void writeDeleted(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            List deleted = this.getList(Diff.ListType.DELETED);
            out.writeInt(deleted.size());
            for (INode node : deleted) {
                FSImageSerialization.saveINode2Image(node, out, true, referenceMap);
            }
        }

        private void write(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            this.writeCreated(out);
            this.writeDeleted(out, referenceMap);
        }

        private void getDirsInDeleted(List<INodeDirectory> dirList) {
            for (INode node : this.getList(Diff.ListType.DELETED)) {
                if (!node.isDirectory()) continue;
                dirList.add(node.asDirectory());
            }
        }

        public List<SnapshotDiffReport.DiffReportEntry> generateReport(byte[][] parentPath, INodeDirectoryWithSnapshot parent, boolean fromEarlier) {
            ArrayList<SnapshotDiffReport.DiffReportEntry> cList = new ArrayList<SnapshotDiffReport.DiffReportEntry>();
            ArrayList<SnapshotDiffReport.DiffReportEntry> dList = new ArrayList<SnapshotDiffReport.DiffReportEntry>();
            int c = 0;
            int d = 0;
            List created = this.getList(Diff.ListType.CREATED);
            List deleted = this.getList(Diff.ListType.DELETED);
            byte[][] fullPath = new byte[parentPath.length + 1][];
            System.arraycopy(parentPath, 0, fullPath, 0, parentPath.length);
            while (c < created.size() && d < deleted.size()) {
                INode dnode;
                INode cnode = (INode)created.get(c);
                if (cnode.compareTo((dnode = (INode)deleted.get(d)).getLocalNameBytes()) == 0) {
                    fullPath[fullPath.length - 1] = cnode.getLocalNameBytes();
                    if (cnode.isSymlink() && dnode.isSymlink()) {
                        dList.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, fullPath));
                    } else {
                        cList.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, fullPath));
                        dList.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, fullPath));
                    }
                    ++c;
                    ++d;
                    continue;
                }
                if (cnode.compareTo(dnode.getLocalNameBytes()) < 0) {
                    fullPath[fullPath.length - 1] = cnode.getLocalNameBytes();
                    cList.add(new SnapshotDiffReport.DiffReportEntry(fromEarlier ? SnapshotDiffReport.DiffType.CREATE : SnapshotDiffReport.DiffType.DELETE, fullPath));
                    ++c;
                    continue;
                }
                fullPath[fullPath.length - 1] = dnode.getLocalNameBytes();
                dList.add(new SnapshotDiffReport.DiffReportEntry(fromEarlier ? SnapshotDiffReport.DiffType.DELETE : SnapshotDiffReport.DiffType.CREATE, fullPath));
                ++d;
            }
            while (d < deleted.size()) {
                fullPath[fullPath.length - 1] = ((INode)deleted.get(d)).getLocalNameBytes();
                dList.add(new SnapshotDiffReport.DiffReportEntry(fromEarlier ? SnapshotDiffReport.DiffType.DELETE : SnapshotDiffReport.DiffType.CREATE, fullPath));
                ++d;
            }
            while (c < created.size()) {
                fullPath[fullPath.length - 1] = ((INode)created.get(c)).getLocalNameBytes();
                cList.add(new SnapshotDiffReport.DiffReportEntry(fromEarlier ? SnapshotDiffReport.DiffType.CREATE : SnapshotDiffReport.DiffType.DELETE, fullPath));
                ++c;
            }
            dList.addAll(cList);
            return dList;
        }
    }
}

