/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import com.facebook.presto.hadoop.shaded.org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStarted;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskStartedEvent
implements HistoryEvent {
    private TaskStarted datum = new TaskStarted();

    public TaskStartedEvent(TaskID id, long startTime, TaskType taskType, String splitLocations) {
        this.datum.taskid = new Utf8(id.toString());
        this.datum.splitLocations = new Utf8(splitLocations);
        this.datum.startTime = startTime;
        this.datum.taskType = new Utf8(taskType.name());
    }

    TaskStartedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskStarted)datum;
    }

    public TaskID getTaskId() {
        return TaskID.forName(((Object)this.datum.taskid).toString());
    }

    public String getSplitLocations() {
        return ((Object)this.datum.splitLocations).toString();
    }

    public long getStartTime() {
        return this.datum.startTime;
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(((Object)this.datum.taskType).toString());
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_STARTED;
    }
}

