/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.stats.QuantileDigest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.Managed;

public class TimeDistribution {
    private static final double MAX_ERROR = 0.01;
    @GuardedBy(value="this")
    private final QuantileDigest digest;
    private final TimeUnit unit;

    public TimeDistribution() {
        this(TimeUnit.SECONDS);
    }

    public TimeDistribution(TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit is null");
        this.digest = new QuantileDigest(0.01);
        this.unit = unit;
    }

    public TimeDistribution(double alpha) {
        this(alpha, TimeUnit.SECONDS);
    }

    public TimeDistribution(double alpha, TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit is null");
        this.digest = new QuantileDigest(0.01, alpha);
        this.unit = unit;
    }

    public synchronized void add(long value) {
        this.digest.add(value);
    }

    @Managed
    public synchronized double getMaxError() {
        return this.digest.getConfidenceFactor();
    }

    @Managed
    public synchronized double getCount() {
        return this.digest.getCount();
    }

    @Managed
    public synchronized double getP50() {
        return this.convertToUnit(this.digest.getQuantile(0.5));
    }

    @Managed
    public synchronized double getP75() {
        return this.convertToUnit(this.digest.getQuantile(0.75));
    }

    @Managed
    public synchronized double getP90() {
        return this.convertToUnit(this.digest.getQuantile(0.9));
    }

    @Managed
    public synchronized double getP95() {
        return this.convertToUnit(this.digest.getQuantile(0.95));
    }

    @Managed
    public synchronized double getP99() {
        return this.convertToUnit(this.digest.getQuantile(0.99));
    }

    @Managed
    public synchronized double getMin() {
        return this.convertToUnit(this.digest.getMin());
    }

    @Managed
    public synchronized double getMax() {
        return this.convertToUnit(this.digest.getMax());
    }

    @Managed
    public TimeUnit getUnit() {
        return this.unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public Map<Double, Double> getPercentiles() {
        List<Long> values;
        ArrayList<Double> percentiles = new ArrayList<Double>(100);
        for (int i = 0; i < 100; ++i) {
            percentiles.add((double)i / 100.0);
        }
        TimeDistribution timeDistribution = this;
        synchronized (timeDistribution) {
            values = this.digest.getQuantiles(percentiles);
        }
        LinkedHashMap<Double, Double> result = new LinkedHashMap<Double, Double>(values.size());
        for (int i = 0; i < percentiles.size(); ++i) {
            result.put((Double)percentiles.get(i), this.convertToUnit(values.get(i)));
        }
        return result;
    }

    private double convertToUnit(long nanos) {
        if (nanos == Long.MAX_VALUE || nanos == Long.MIN_VALUE) {
            return Double.NaN;
        }
        return (double)nanos * 1.0 / (double)this.unit.toNanos(1L);
    }

    public TimeDistributionSnapshot snapshot() {
        return new TimeDistributionSnapshot(this.getMaxError(), this.getCount(), this.getP50(), this.getP75(), this.getP90(), this.getP95(), this.getP99(), this.getMin(), this.getMax(), this.getUnit());
    }

    public static class TimeDistributionSnapshot {
        private final double maxError;
        private final double count;
        private final double p50;
        private final double p75;
        private final double p90;
        private final double p95;
        private final double p99;
        private final double min;
        private final double max;
        private final TimeUnit unit;

        @JsonCreator
        public TimeDistributionSnapshot(@JsonProperty(value="maxError") double maxError, @JsonProperty(value="count") double count, @JsonProperty(value="p50") double p50, @JsonProperty(value="p75") double p75, @JsonProperty(value="p90") double p90, @JsonProperty(value="p95") double p95, @JsonProperty(value="p99") double p99, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max, @JsonProperty(value="unit") TimeUnit unit) {
            this.maxError = maxError;
            this.count = count;
            this.p50 = p50;
            this.p75 = p75;
            this.p90 = p90;
            this.p95 = p95;
            this.p99 = p99;
            this.min = min;
            this.max = max;
            this.unit = unit;
        }

        @JsonProperty
        public double getMaxError() {
            return this.maxError;
        }

        @JsonProperty
        public double getCount() {
            return this.count;
        }

        @JsonProperty
        public double getP50() {
            return this.p50;
        }

        @JsonProperty
        public double getP75() {
            return this.p75;
        }

        @JsonProperty
        public double getP90() {
            return this.p90;
        }

        @JsonProperty
        public double getP95() {
            return this.p95;
        }

        @JsonProperty
        public double getP99() {
            return this.p99;
        }

        @JsonProperty
        public double getMin() {
            return this.min;
        }

        @JsonProperty
        public double getMax() {
            return this.max;
        }

        @JsonProperty
        public TimeUnit unit() {
            return this.unit;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("maxError", this.maxError).add("count", this.count).add("p50", this.p50).add("p75", this.p75).add("p90", this.p90).add("p95", this.p95).add("p99", this.p99).add("min", this.min).add("max", this.max).add("unit", (Object)this.unit).toString();
        }
    }
}

