/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBooleanParser;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NumberParser;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.ByteArrays;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

class ColumnarBinaryHiveRecordCursor<K>
extends HiveRecordCursor {
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private final RecordReader<K, BytesRefArrayWritable> recordReader;
    private final DateTimeZone sessionTimeZone;
    private final K key;
    private final BytesRefArrayWritable value;
    private final String[] names;
    private final Type[] types;
    private final HiveType[] hiveTypes;
    private final ObjectInspector[] fieldInspectors;
    private final int[] hiveColumnIndexes;
    private final boolean[] isPartitionColumn;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final boolean[] nulls;
    private final long totalBytes;
    private long completedBytes;
    private boolean closed;
    private static final byte HIVE_EMPTY_STRING_BYTE = -65;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    private static final Set<HiveType> VALID_HIVE_STRING_TYPES = ImmutableSet.of((Object)HiveType.HIVE_BINARY, (Object)HiveType.HIVE_STRING);
    private static final Set<ObjectInspector.Category> VALID_HIVE_STRING_CATEGORIES = ImmutableSet.of((Object)ObjectInspector.Category.LIST, (Object)ObjectInspector.Category.MAP, (Object)ObjectInspector.Category.STRUCT);

    public ColumnarBinaryHiveRecordCursor(RecordReader<K, BytesRefArrayWritable> recordReader, long totalBytes, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone, TypeManager typeManager) {
        Preconditions.checkNotNull(recordReader, (Object)"recordReader is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Preconditions.checkNotNull((Object)splitSchema, (Object)"splitSchema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkNotNull((Object)sessionTimeZone, (Object)"sessionTimeZone is null");
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.key = recordReader.createKey();
        this.value = (BytesRefArrayWritable)recordReader.createValue();
        this.sessionTimeZone = sessionTimeZone;
        int size = columns.size();
        this.names = new String[size];
        this.types = new Type[size];
        this.hiveTypes = new HiveType[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.hiveColumnIndexes = new int[size];
        this.isPartitionColumn = new boolean[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.nulls = new boolean[size];
        StructObjectInspector rowInspector = HiveUtil.getTableObjectInspector(splitSchema);
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = columns.get(i);
            this.names[i] = column.getName();
            this.types[i] = typeManager.getType(column.getTypeSignature());
            this.hiveTypes[i] = column.getHiveType();
            if (!column.isPartitionKey()) {
                this.fieldInspectors[i] = rowInspector.getStructFieldRef(column.getName()).getFieldObjectInspector();
            }
            this.hiveColumnIndexes[i] = column.getHiveColumnIndex();
            this.isPartitionColumn[i] = column.isPartitionKey();
        }
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey.nameGetter());
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            if (!column.isPartitionKey()) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{column.getName()});
            byte[] bytes = partitionKey.getValue().getBytes(Charsets.UTF_8);
            Type type = this.types[columnIndex];
            if (HiveUtil.isHiveNull(bytes)) {
                this.nulls[columnIndex] = true;
                continue;
            }
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                if (HiveBooleanParser.isTrue(bytes, 0, bytes.length)) {
                    this.booleans[columnIndex] = true;
                    continue;
                }
                if (HiveBooleanParser.isFalse(bytes, 0, bytes.length)) {
                    this.booleans[columnIndex] = false;
                    continue;
                }
                String valueString = new String(bytes, Charsets.UTF_8);
                throw new IllegalArgumentException(String.format("Invalid partition value '%s' for BOOLEAN partition key %s", valueString, this.names[columnIndex]));
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                if (bytes.length == 0) {
                    throw new IllegalArgumentException(String.format("Invalid partition value '' for BIGINT partition key %s", this.names[columnIndex]));
                }
                this.longs[columnIndex] = NumberParser.parseLong(bytes, 0, bytes.length);
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)type)) {
                if (bytes.length == 0) {
                    throw new IllegalArgumentException(String.format("Invalid partition value '' for DOUBLE partition key %s", this.names[columnIndex]));
                }
                this.doubles[columnIndex] = NumberParser.parseDouble(bytes, 0, bytes.length);
                continue;
            }
            if (VarcharType.VARCHAR.equals((Object)type)) {
                this.slices[columnIndex] = Slices.wrappedBuffer((byte[])bytes);
                continue;
            }
            if (DateType.DATE.equals((Object)type)) {
                this.longs[columnIndex] = ISODateTimeFormat.date().withZoneUTC().parseMillis(partitionKey.getValue());
                continue;
            }
            if (TimestampType.TIMESTAMP.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.parseHiveTimestamp(partitionKey.getValue(), hiveStorageTimeZone);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.next(this.key, (Object)this.value)) {
                this.close();
                return false;
            }
            System.arraycopy(this.isPartitionColumn, 0, this.loaded, 0, this.isPartitionColumn.length);
            return true;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, (Type)BooleanType.BOOLEAN);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseBooleanColumn(column, bytes, start, length);
        }
    }

    private void parseBooleanColumn(int column, byte[] bytes, int start, int length) {
        if (length > 0) {
            this.booleans[column] = bytes[start] != 0;
            this.nulls[column] = false;
        } else {
            this.nulls[column] = true;
        }
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!(this.types[fieldId].equals(BigintType.BIGINT) || this.types[fieldId].equals(DateType.DATE) || this.types[fieldId].equals(TimestampType.TIMESTAMP))) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, %s or %s , actual %s (field %s)", BigintType.BIGINT, DateType.DATE, TimestampType.TIMESTAMP, this.types[fieldId], fieldId));
        }
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseLongColumn(column, bytes, start, length);
        }
    }

    private void parseLongColumn(int column, byte[] bytes, int start, int length) {
        if (length == 0) {
            this.nulls[column] = true;
            return;
        }
        this.nulls[column] = false;
        if (this.hiveTypes[column].equals(HiveType.HIVE_SHORT)) {
            Preconditions.checkState((length == 2 ? 1 : 0) != 0, (Object)"Short should be 2 bytes");
            this.longs[column] = Short.reverseBytes(ByteArrays.getShort((byte[])bytes, (int)start));
        } else if (this.hiveTypes[column].equals(HiveType.HIVE_DATE)) {
            Preconditions.checkState((length >= 1 ? 1 : 0) != 0, (Object)"Date should be at least 1 byte");
            long daysSinceEpoch = ColumnarBinaryHiveRecordCursor.readVInt(bytes, start, length);
            this.longs[column] = daysSinceEpoch * MILLIS_IN_DAY;
        } else if (this.hiveTypes[column].equals(HiveType.HIVE_TIMESTAMP)) {
            Preconditions.checkState((length >= 1 ? 1 : 0) != 0, (Object)"Timestamp should be at least 1 byte");
            long seconds = TimestampWritable.getSeconds((byte[])bytes, (int)start);
            long nanos = TimestampWritable.getNanos((byte[])bytes, (int)(start + 4));
            this.longs[column] = seconds * 1000L + nanos / 1000000L;
        } else if (this.hiveTypes[column].equals(HiveType.HIVE_BYTE)) {
            Preconditions.checkState((length == 1 ? 1 : 0) != 0, (Object)"Byte should be 1 byte");
            this.longs[column] = bytes[start];
        } else if (this.hiveTypes[column].equals(HiveType.HIVE_INT)) {
            Preconditions.checkState((length >= 1 ? 1 : 0) != 0, (Object)"Int should be at least 1 byte");
            this.longs[column] = length == 1 ? (long)bytes[start] : ColumnarBinaryHiveRecordCursor.readVInt(bytes, start, length);
        } else if (this.hiveTypes[column].equals(HiveType.HIVE_LONG)) {
            Preconditions.checkState((length >= 1 ? 1 : 0) != 0, (Object)"Long should be at least 1 byte");
            this.longs[column] = length == 1 ? (long)bytes[start] : ColumnarBinaryHiveRecordCursor.readVInt(bytes, start, length);
        } else {
            throw new RuntimeException(String.format("%s is not a valid LONG type", this.hiveTypes[column]));
        }
    }

    private static long readVInt(byte[] bytes, int start, int length) {
        long value = 0L;
        for (int i = 1; i < length; ++i) {
            value <<= 8;
            value |= (long)(bytes[start + i] & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)bytes[start]) ? value ^ 0xFFFFFFFFFFFFFFFFL : value;
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, (Type)DoubleType.DOUBLE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseDoubleColumn(column, bytes, start, length);
        }
    }

    private void parseDoubleColumn(int column, byte[] bytes, int start, int length) {
        if (length == 0) {
            this.nulls[column] = true;
        } else {
            this.nulls[column] = false;
            if (this.hiveTypes[column].equals(HiveType.HIVE_FLOAT)) {
                Preconditions.checkState((length == 4 ? 1 : 0) != 0, (Object)"Float should be 4 bytes");
                int intBits = ByteArrays.getInt((byte[])bytes, (int)start);
                this.doubles[column] = Float.intBitsToFloat(Integer.reverseBytes(intBits));
            } else if (this.hiveTypes[column].equals(HiveType.HIVE_DOUBLE)) {
                Preconditions.checkState((length == 8 ? 1 : 0) != 0, (Object)"Double should be 8 bytes");
                long longBits = ByteArrays.getLong((byte[])bytes, (int)start);
                this.doubles[column] = Double.longBitsToDouble(Long.reverseBytes(longBits));
            } else {
                throw new RuntimeException(String.format("%s is not a valid DOUBLE type", this.hiveTypes[column]));
            }
        }
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        Type type = this.types[fieldId];
        if (!(type.equals(VarcharType.VARCHAR) || type.equals(VarbinaryType.VARBINARY) || HiveUtil.isStructuralType(this.hiveTypes[fieldId]))) {
            throw new IllegalArgumentException(String.format("Expected field to be VARCHAR or VARBINARY, actual %s (field %s)", type, fieldId));
        }
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.slices[fieldId];
    }

    private void parseStringColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseStringColumn(column, bytes, start, length);
        }
    }

    private void parseStringColumn(int column, byte[] bytes, int start, int length) {
        Preconditions.checkState((VALID_HIVE_STRING_TYPES.contains(this.hiveTypes[column]) || VALID_HIVE_STRING_CATEGORIES.contains(this.hiveTypes[column].getCategory()) ? 1 : 0) != 0, (String)"%s is not a valid STRING type", (Object[])new Object[]{this.hiveTypes[column]});
        if (length == 0) {
            this.nulls[column] = true;
        } else {
            this.nulls[column] = false;
            if (HiveUtil.isStructuralType(this.hiveTypes[column])) {
                LazyBinaryObject lazyObject = LazyBinaryFactory.createLazyBinaryObject((ObjectInspector)this.fieldInspectors[column]);
                ByteArrayRef byteArrayRef = new ByteArrayRef();
                byteArrayRef.setData(bytes);
                lazyObject.init(byteArrayRef, start, length);
                this.slices[column] = Slices.wrappedBuffer((byte[])SerDeUtils.getJsonBytes(this.sessionTimeZone, lazyObject.getObject(), this.fieldInspectors[column]));
            } else {
                this.slices[column] = this.hiveTypes[column].equals(HiveType.HIVE_STRING) && length == 1 && bytes[start] == -65 ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])Arrays.copyOfRange(bytes, start, start + length));
            }
        }
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        Type type = this.types[column];
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            this.parseBooleanColumn(column);
        } else if (BigintType.BIGINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            this.parseDoubleColumn(column);
        } else if (VarcharType.VARCHAR.equals((Object)type) || VarbinaryType.VARBINARY.equals((Object)type) || HiveUtil.isStructuralType(this.hiveTypes[column])) {
            this.parseStringColumn(column);
        } else if (DateType.DATE.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            this.parseLongColumn(column);
        } else {
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    private void validateType(int fieldId, Type type) {
        if (!this.types[fieldId].equals(type)) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", type, this.types[fieldId], fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

