/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ColumnarTextHiveRecordCursor;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;

public class ColumnarTextHiveRecordCursorProvider
implements HiveRecordCursorProvider {
    @Override
    public Optional<HiveRecordCursor> createHiveRecordCursor(String clientId, Configuration configuration, ConnectorSession session, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        if (!ColumnarTextHiveRecordCursorProvider.usesColumnarTextSerDe(schema)) {
            return Optional.absent();
        }
        RecordReader<?, ?> recordReader = HiveUtil.createRecordReader(clientId, configuration, path, start, length, schema, columns, typeManager);
        return Optional.of(new ColumnarTextHiveRecordCursor(ColumnarTextHiveRecordCursorProvider.columnarTextRecordReader(recordReader), length, schema, partitionKeys, columns, hiveStorageTimeZone, DateTimeZone.forID((String)session.getTimeZoneKey().getId()), typeManager));
    }

    private static boolean usesColumnarTextSerDe(Properties schema) {
        return HiveUtil.getDeserializer(schema) instanceof ColumnarSerDe;
    }

    private static RecordReader<?, BytesRefArrayWritable> columnarTextRecordReader(RecordReader<?, ?> recordReader) {
        return recordReader;
    }
}

