/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBooleanParser;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NumberParser;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

class GenericHiveRecordCursor<K, V extends Writable>
extends HiveRecordCursor {
    private final RecordReader<K, V> recordReader;
    private final K key;
    private final V value;
    private final Deserializer deserializer;
    private final Type[] types;
    private final HiveType[] hiveTypes;
    private final StructObjectInspector rowInspector;
    private final ObjectInspector[] fieldInspectors;
    private final StructField[] structFields;
    private final boolean[] isPartitionColumn;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final boolean[] nulls;
    private final long totalBytes;
    private final DateTimeZone hiveStorageTimeZone;
    private final DateTimeZone sessionTimeZone;
    private long completedBytes;
    private Object rowData;
    private boolean closed;

    public GenericHiveRecordCursor(RecordReader<K, V> recordReader, long totalBytes, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone, TypeManager typeManager) {
        Preconditions.checkNotNull(recordReader, (Object)"recordReader is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Preconditions.checkNotNull((Object)splitSchema, (Object)"splitSchema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null");
        Preconditions.checkNotNull((Object)sessionTimeZone, (Object)"sessionTimeZone is null");
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.key = recordReader.createKey();
        this.value = (Writable)recordReader.createValue();
        this.hiveStorageTimeZone = hiveStorageTimeZone;
        this.sessionTimeZone = sessionTimeZone;
        this.deserializer = HiveUtil.getDeserializer(splitSchema);
        this.rowInspector = HiveUtil.getTableObjectInspector(this.deserializer);
        int size = columns.size();
        String[] names = new String[size];
        this.types = new Type[size];
        this.hiveTypes = new HiveType[size];
        this.structFields = new StructField[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.isPartitionColumn = new boolean[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.nulls = new boolean[size];
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = columns.get(i);
            names[i] = column.getName();
            this.types[i] = typeManager.getType(column.getTypeSignature());
            this.hiveTypes[i] = column.getHiveType();
            if (!column.isPartitionKey()) {
                StructField field;
                this.structFields[i] = field = this.rowInspector.getStructFieldRef(column.getName());
                this.fieldInspectors[i] = field.getFieldObjectInspector();
            }
            this.isPartitionColumn[i] = column.isPartitionKey();
        }
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey.nameGetter());
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            if (!column.isPartitionKey()) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{column.getName()});
            byte[] bytes = partitionKey.getValue().getBytes(Charsets.UTF_8);
            Type type = this.types[columnIndex];
            if (HiveUtil.isHiveNull(bytes)) {
                this.nulls[columnIndex] = true;
                continue;
            }
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                if (HiveBooleanParser.isTrue(bytes, 0, bytes.length)) {
                    this.booleans[columnIndex] = true;
                    continue;
                }
                if (HiveBooleanParser.isFalse(bytes, 0, bytes.length)) {
                    this.booleans[columnIndex] = false;
                    continue;
                }
                String valueString = new String(bytes, Charsets.UTF_8);
                throw new IllegalArgumentException(String.format("Invalid partition value '%s' for BOOLEAN partition key %s", valueString, names[columnIndex]));
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                if (bytes.length == 0) {
                    throw new IllegalArgumentException(String.format("Invalid partition value '' for BIGINT partition key %s", names[columnIndex]));
                }
                this.longs[columnIndex] = NumberParser.parseLong(bytes, 0, bytes.length);
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)type)) {
                if (bytes.length == 0) {
                    throw new IllegalArgumentException(String.format("Invalid partition value '' for DOUBLE partition key %s", names[columnIndex]));
                }
                this.doubles[columnIndex] = NumberParser.parseDouble(bytes, 0, bytes.length);
                continue;
            }
            if (VarcharType.VARCHAR.equals((Object)type)) {
                this.slices[columnIndex] = Slices.wrappedBuffer((byte[])Arrays.copyOf(bytes, bytes.length));
                continue;
            }
            if (DateType.DATE.equals((Object)type)) {
                this.longs[columnIndex] = ISODateTimeFormat.date().withZoneUTC().parseMillis(partitionKey.getValue());
                continue;
            }
            if (TimestampType.TIMESTAMP.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.parseHiveTimestamp(partitionKey.getValue(), hiveStorageTimeZone);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.next(this.key, this.value)) {
                this.close();
                return false;
            }
            System.arraycopy(this.isPartitionColumn, 0, this.loaded, 0, this.isPartitionColumn.length);
            this.rowData = this.deserializer.deserialize(this.value);
            return true;
        }
        catch (IOException | RuntimeException | SerDeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.booleans[column] = (Boolean)fieldValue;
            this.nulls[column] = false;
        }
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.longs[column] = GenericHiveRecordCursor.getLongOrTimestamp(fieldValue, this.hiveStorageTimeZone);
            this.nulls[column] = false;
        }
    }

    private static long getLongOrTimestamp(Object value, DateTimeZone hiveTimeZone) {
        if (value instanceof Date) {
            long storageTime = ((Date)value).getTime();
            long utcMillis = storageTime + (long)DateTimeZone.getDefault().getOffset(storageTime);
            return utcMillis;
        }
        if (value instanceof Timestamp) {
            long parsedJvmMillis = ((Timestamp)value).getTime();
            DateTimeZone jvmTimeZone = DateTimeZone.getDefault();
            long hiveMillis = jvmTimeZone.convertUTCToLocal(parsedJvmMillis);
            long utcMillis = hiveTimeZone.convertLocalToUTC(hiveMillis, false);
            return utcMillis;
        }
        return ((Number)value).longValue();
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.doubles[column] = ((Number)fieldValue).doubleValue();
            this.nulls[column] = false;
        }
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Slice.class);
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.slices[fieldId];
    }

    private void parseStringColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else if (HiveUtil.isStructuralType(this.hiveTypes[column])) {
            this.slices[column] = Slices.wrappedBuffer((byte[])SerDeUtils.getJsonBytes(this.sessionTimeZone, fieldData, this.fieldInspectors[column]));
            this.nulls[column] = false;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            if (fieldValue instanceof String) {
                this.slices[column] = Slices.utf8Slice((String)((String)fieldValue));
            } else if (fieldValue instanceof byte[]) {
                this.slices[column] = Slices.wrappedBuffer((byte[])((byte[])fieldValue));
            } else {
                throw new IllegalStateException("unsupported string field type: " + fieldValue.getClass().getName());
            }
            this.nulls[column] = false;
        }
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        Type type = this.types[column];
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            this.parseBooleanColumn(column);
        } else if (BigintType.BIGINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            this.parseDoubleColumn(column);
        } else if (VarcharType.VARCHAR.equals((Object)type) || VarbinaryType.VARBINARY.equals((Object)type) || HiveUtil.isStructuralType(this.hiveTypes[column])) {
            this.parseStringColumn(column);
        } else if (DateType.DATE.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            this.parseLongColumn(column);
        } else {
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    private void validateType(int fieldId, Class<?> type) {
        if (!this.types[fieldId].getJavaType().equals(type)) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", type, this.types[fieldId], fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

