/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.DefaultHivePartitioner;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

final class HiveBucketing {
    private static final Logger log = Logger.get(HiveBucketing.class);
    private static final Set<PrimitiveObjectInspector.PrimitiveCategory> SUPPORTED_TYPES = Sets.immutableEnumSet((Enum)PrimitiveObjectInspector.PrimitiveCategory.BYTE, (Enum[])new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.SHORT, PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.LONG, PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, PrimitiveObjectInspector.PrimitiveCategory.STRING});

    private HiveBucketing() {
    }

    public static Optional<HiveBucket> getHiveBucket(Table table, Map<ConnectorColumnHandle, ?> bindings) {
        if (!table.getSd().isSetBucketCols() || table.getSd().getBucketCols().isEmpty() || !table.getSd().isSetNumBuckets() || table.getSd().getNumBuckets() <= 0 || bindings.isEmpty()) {
            return Optional.absent();
        }
        List bucketColumns = table.getSd().getBucketCols();
        HashMap<String, ObjectInspector> objectInspectors = new HashMap<String, ObjectInspector>();
        for (StructField structField : HiveUtil.getTableStructFields(table)) {
            objectInspectors.put(structField.getFieldName(), structField.getFieldObjectInspector());
        }
        for (String string : bucketColumns) {
            ObjectInspector inspector = (ObjectInspector)objectInspectors.get(string);
            if (inspector == null || inspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                return Optional.absent();
            }
            if (SUPPORTED_TYPES.contains(((PrimitiveObjectInspector)inspector).getPrimitiveCategory())) continue;
            return Optional.absent();
        }
        HashMap bucketBindings = new HashMap();
        for (Map.Entry<ConnectorColumnHandle, ?> entry : bindings.entrySet()) {
            HiveColumnHandle colHandle = (HiveColumnHandle)entry.getKey();
            if (!bucketColumns.contains(colHandle.getName())) continue;
            bucketBindings.put(colHandle.getName(), entry.getValue());
        }
        if (bucketBindings.size() != bucketColumns.size()) {
            return Optional.absent();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String column : bucketColumns) {
            builder.add((Object)Maps.immutableEntry(objectInspectors.get(column), bucketBindings.get(column)));
        }
        return HiveBucketing.getHiveBucket((List<Map.Entry<ObjectInspector, Object>>)builder.build(), table.getSd().getNumBuckets());
    }

    public static Optional<HiveBucket> getHiveBucket(List<Map.Entry<ObjectInspector, Object>> columnBindings, int bucketCount) {
        try {
            GenericUDFHash udf = new GenericUDFHash();
            ObjectInspector[] objectInspectors = new ObjectInspector[columnBindings.size()];
            GenericUDF.DeferredObject[] deferredObjects = new GenericUDF.DeferredObject[columnBindings.size()];
            int i = 0;
            for (Map.Entry<ObjectInspector, Object> entry : columnBindings) {
                objectInspectors[i] = HiveBucketing.getJavaObjectInspector(entry.getKey());
                deferredObjects[i] = HiveBucketing.getJavaDeferredObject(entry.getValue(), entry.getKey());
                ++i;
            }
            ObjectInspector udfInspector = udf.initialize(objectInspectors);
            IntObjectInspector inspector = Types.checkType(udfInspector, IntObjectInspector.class, "udfInspector");
            Object result = udf.evaluate(deferredObjects);
            HiveKey hiveKey = new HiveKey();
            hiveKey.setHashCode(inspector.get(result));
            int bucketNumber = new DefaultHivePartitioner().getBucket((Object)hiveKey, null, bucketCount);
            return Optional.of((Object)new HiveBucket(bucketNumber, bucketCount));
        }
        catch (HiveException e) {
            log.debug((Throwable)e, "Error evaluating bucket number");
            return Optional.absent();
        }
    }

    private static ObjectInspector getJavaObjectInspector(ObjectInspector objectInspector) {
        Preconditions.checkArgument((objectInspector.getCategory() == ObjectInspector.Category.PRIMITIVE ? 1 : 0) != 0, (String)"Unsupported object inspector category %s", (Object[])new Object[]{objectInspector.getCategory()});
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objectInspector;
        switch (poi.getPrimitiveCategory()) {
            case BOOLEAN: {
                return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
            }
            case BYTE: {
                return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
            }
            case SHORT: {
                return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
            }
            case INT: {
                return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
            }
            case LONG: {
                return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
            }
            case STRING: {
                return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
            }
        }
        throw new RuntimeException("Unsupported type: " + poi.getPrimitiveCategory());
    }

    private static GenericUDF.DeferredObject getJavaDeferredObject(Object object, ObjectInspector objectInspector) {
        Preconditions.checkArgument((objectInspector.getCategory() == ObjectInspector.Category.PRIMITIVE ? 1 : 0) != 0, (String)"Unsupported object inspector category %s", (Object[])new Object[]{objectInspector.getCategory()});
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objectInspector;
        switch (poi.getPrimitiveCategory()) {
            case BOOLEAN: {
                return new GenericUDF.DeferredJavaObject(object);
            }
            case BYTE: {
                return new GenericUDF.DeferredJavaObject((Object)((Long)object).byteValue());
            }
            case SHORT: {
                return new GenericUDF.DeferredJavaObject((Object)((Long)object).shortValue());
            }
            case INT: {
                return new GenericUDF.DeferredJavaObject((Object)((Long)object).intValue());
            }
            case LONG: {
                return new GenericUDF.DeferredJavaObject(object);
            }
            case STRING: {
                return new GenericUDF.DeferredJavaObject((Object)((Slice)object).toStringUtf8());
            }
        }
        throw new RuntimeException("Unsupported type: " + poi.getPrimitiveCategory());
    }

    public static class HiveBucket {
        private final int bucketNumber;
        private final int bucketCount;

        public HiveBucket(int bucketNumber, int bucketCount) {
            Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be greater than zero");
            Preconditions.checkArgument((bucketNumber >= 0 ? 1 : 0) != 0, (Object)"bucketCount must be positive");
            Preconditions.checkArgument((bucketNumber < bucketCount ? 1 : 0) != 0, (Object)"bucketNumber must be less than bucketCount");
            this.bucketNumber = bucketNumber;
            this.bucketCount = bucketCount;
        }

        public int getBucketNumber() {
            return this.bucketNumber;
        }

        public int getBucketCount() {
            return this.bucketCount;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("bucketNumber", this.bucketNumber).add("bucketCount", this.bucketCount).toString();
        }
    }
}

