/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveStorageFormat;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HiveClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private TimeZone timeZone = TimeZone.getDefault();
    private DataSize maxSplitSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private int maxOutstandingSplits = 1000;
    private int maxGlobalSplitIteratorThreads = 1000;
    private int maxSplitIteratorThreads = 50;
    private int minPartitionBatchSize = 10;
    private int maxPartitionBatchSize = 100;
    private int maxInitialSplits = 200;
    private DataSize maxInitialSplitSize;
    private boolean forceLocalScheduling;
    private boolean allowDropTable;
    private boolean allowRenameTable;
    private boolean allowCorruptWritesForTesting;
    private Duration metastoreCacheTtl = new Duration(1.0, TimeUnit.HOURS);
    private Duration metastoreRefreshInterval = new Duration(2.0, TimeUnit.MINUTES);
    private int maxMetastoreRefreshThreads = 100;
    private HostAndPort metastoreSocksProxy;
    private Duration metastoreTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsConnectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private int dfsConnectMaxRetries = 5;
    private boolean verifyChecksum = true;
    private String domainSocketPath;
    private String s3AwsAccessKey;
    private String s3AwsSecretKey;
    private boolean s3SslEnabled = true;
    private int s3MaxClientRetries = 3;
    private int s3MaxErrorRetries = 10;
    private Duration s3MaxBackoffTime = new Duration(10.0, TimeUnit.MINUTES);
    private Duration s3MaxRetryTime = new Duration(10.0, TimeUnit.MINUTES);
    private Duration s3ConnectTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private Duration s3SocketTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private int s3MaxConnections = 500;
    private File s3StagingDirectory = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value());
    private DataSize s3MultipartMinFileSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize s3MultipartMinPartSize = new DataSize(5.0, DataSize.Unit.MEGABYTE);
    private HiveStorageFormat hiveStorageFormat = HiveStorageFormat.RCBINARY;
    private List<String> resourceConfigFiles;
    private boolean optimizedReaderEnabled = true;

    public int getMaxInitialSplits() {
        return this.maxInitialSplits;
    }

    @Config(value="hive.max-initial-splits")
    public HiveClientConfig setMaxInitialSplits(int maxInitialSplits) {
        this.maxInitialSplits = maxInitialSplits;
        return this;
    }

    public DataSize getMaxInitialSplitSize() {
        if (this.maxInitialSplitSize == null) {
            return new DataSize(this.maxSplitSize.getValue() / 2.0, this.maxSplitSize.getUnit());
        }
        return this.maxInitialSplitSize;
    }

    @Config(value="hive.max-initial-split-size")
    public HiveClientConfig setMaxInitialSplitSize(DataSize maxInitialSplitSize) {
        this.maxInitialSplitSize = maxInitialSplitSize;
        return this;
    }

    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @Config(value="hive.force-local-scheduling")
    public HiveClientConfig setForceLocalScheduling(boolean forceLocalScheduling) {
        this.forceLocalScheduling = forceLocalScheduling;
        return this;
    }

    @NotNull
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Config(value="hive.time-zone")
    public HiveClientConfig setTimeZone(String id) {
        this.timeZone = id == null ? TimeZone.getDefault() : TimeZone.getTimeZone(id);
        return this;
    }

    public HiveClientConfig setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        return this;
    }

    @NotNull
    public DataSize getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Config(value="hive.max-split-size")
    public HiveClientConfig setMaxSplitSize(DataSize maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
        return this;
    }

    @Min(value=1L)
    public int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hive.max-outstanding-splits")
    public HiveClientConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public int getMaxSplitIteratorThreads() {
        return this.maxSplitIteratorThreads;
    }

    @Config(value="hive.max-split-iterator-threads")
    public HiveClientConfig setMaxSplitIteratorThreads(int maxSplitIteratorThreads) {
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        return this;
    }

    @Min(value=1L)
    public int getMaxGlobalSplitIteratorThreads() {
        return this.maxGlobalSplitIteratorThreads;
    }

    @Config(value="hive.max-global-split-iterator-threads")
    public HiveClientConfig setMaxGlobalSplitIteratorThreads(int maxGlobalSplitIteratorThreads) {
        this.maxGlobalSplitIteratorThreads = maxGlobalSplitIteratorThreads;
        return this;
    }

    public boolean getAllowRenameTable() {
        return this.allowRenameTable;
    }

    @Config(value="hive.allow-rename-table")
    @ConfigDescription(value="Allow hive connector to rename table")
    public HiveClientConfig setAllowRenameTable(boolean allowRenameTable) {
        this.allowRenameTable = allowRenameTable;
        return this;
    }

    @Deprecated
    public boolean getAllowCorruptWritesForTesting() {
        return this.allowCorruptWritesForTesting;
    }

    @Deprecated
    @Config(value="hive.allow-corrupt-writes-for-testing")
    @ConfigDescription(value="Allow Hive connector to write data even when data will likely be corrupt")
    public HiveClientConfig setAllowCorruptWritesForTesting(boolean allowCorruptWritesForTesting) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        return this;
    }

    public boolean getAllowDropTable() {
        return this.allowDropTable;
    }

    @Config(value="hive.allow-drop-table")
    @ConfigDescription(value="Allow Hive connector to drop table")
    public HiveClientConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    @NotNull
    public Duration getMetastoreCacheTtl() {
        return this.metastoreCacheTtl;
    }

    @Config(value="hive.metastore-cache-ttl")
    public HiveClientConfig setMetastoreCacheTtl(Duration metastoreCacheTtl) {
        this.metastoreCacheTtl = metastoreCacheTtl;
        return this;
    }

    @NotNull
    public Duration getMetastoreRefreshInterval() {
        return this.metastoreRefreshInterval;
    }

    @Config(value="hive.metastore-refresh-interval")
    public HiveClientConfig setMetastoreRefreshInterval(Duration metastoreRefreshInterval) {
        this.metastoreRefreshInterval = metastoreRefreshInterval;
        return this;
    }

    @Min(value=1L)
    public int getMaxMetastoreRefreshThreads() {
        return this.maxMetastoreRefreshThreads;
    }

    @Config(value="hive.metastore-refresh-max-threads")
    public HiveClientConfig setMaxMetastoreRefreshThreads(int maxMetastoreRefreshThreads) {
        this.maxMetastoreRefreshThreads = maxMetastoreRefreshThreads;
        return this;
    }

    public HostAndPort getMetastoreSocksProxy() {
        return this.metastoreSocksProxy;
    }

    @Config(value="hive.metastore.thrift.client.socks-proxy")
    public HiveClientConfig setMetastoreSocksProxy(HostAndPort metastoreSocksProxy) {
        this.metastoreSocksProxy = metastoreSocksProxy;
        return this;
    }

    @NotNull
    public Duration getMetastoreTimeout() {
        return this.metastoreTimeout;
    }

    @Config(value="hive.metastore-timeout")
    public HiveClientConfig setMetastoreTimeout(Duration metastoreTimeout) {
        this.metastoreTimeout = metastoreTimeout;
        return this;
    }

    @Min(value=1L)
    public int getMinPartitionBatchSize() {
        return this.minPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.min")
    public HiveClientConfig setMinPartitionBatchSize(int minPartitionBatchSize) {
        this.minPartitionBatchSize = minPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    public int getMaxPartitionBatchSize() {
        return this.maxPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.max")
    public HiveClientConfig setMaxPartitionBatchSize(int maxPartitionBatchSize) {
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        return this;
    }

    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="hive.config.resources")
    public HiveClientConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = files == null ? null : SPLITTER.splitToList((CharSequence)files);
        return this;
    }

    public HiveClientConfig setResourceConfigFiles(List<String> files) {
        this.resourceConfigFiles = files == null ? null : ImmutableList.copyOf(files);
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getDfsTimeout() {
        return this.dfsTimeout;
    }

    @Config(value="hive.dfs-timeout")
    public HiveClientConfig setDfsTimeout(Duration dfsTimeout) {
        this.dfsTimeout = dfsTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getDfsConnectTimeout() {
        return this.dfsConnectTimeout;
    }

    @Config(value="hive.dfs.connect.timeout")
    public HiveClientConfig setDfsConnectTimeout(Duration dfsConnectTimeout) {
        this.dfsConnectTimeout = dfsConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public int getDfsConnectMaxRetries() {
        return this.dfsConnectMaxRetries;
    }

    @Config(value="hive.dfs.connect.max-retries")
    public HiveClientConfig setDfsConnectMaxRetries(int dfsConnectMaxRetries) {
        this.dfsConnectMaxRetries = dfsConnectMaxRetries;
        return this;
    }

    public HiveStorageFormat getHiveStorageFormat() {
        return this.hiveStorageFormat;
    }

    @Config(value="hive.storage-format")
    public HiveClientConfig setHiveStorageFormat(HiveStorageFormat hiveStorageFormat) {
        this.hiveStorageFormat = hiveStorageFormat;
        return this;
    }

    public String getDomainSocketPath() {
        return this.domainSocketPath;
    }

    @Config(value="dfs.domain-socket-path")
    public HiveClientConfig setDomainSocketPath(String domainSocketPath) {
        this.domainSocketPath = domainSocketPath;
        return this;
    }

    public boolean isVerifyChecksum() {
        return this.verifyChecksum;
    }

    @Config(value="hive.dfs.verify-checksum")
    public HiveClientConfig setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
        return this;
    }

    public String getS3AwsAccessKey() {
        return this.s3AwsAccessKey;
    }

    @Config(value="hive.s3.aws-access-key")
    public HiveClientConfig setS3AwsAccessKey(String s3AwsAccessKey) {
        this.s3AwsAccessKey = s3AwsAccessKey;
        return this;
    }

    public String getS3AwsSecretKey() {
        return this.s3AwsSecretKey;
    }

    @Config(value="hive.s3.aws-secret-key")
    public HiveClientConfig setS3AwsSecretKey(String s3AwsSecretKey) {
        this.s3AwsSecretKey = s3AwsSecretKey;
        return this;
    }

    public boolean isS3SslEnabled() {
        return this.s3SslEnabled;
    }

    @Config(value="hive.s3.ssl.enabled")
    public HiveClientConfig setS3SslEnabled(boolean s3SslEnabled) {
        this.s3SslEnabled = s3SslEnabled;
        return this;
    }

    @Min(value=0L)
    public int getS3MaxClientRetries() {
        return this.s3MaxClientRetries;
    }

    @Config(value="hive.s3.max-client-retries")
    public HiveClientConfig setS3MaxClientRetries(int s3MaxClientRetries) {
        this.s3MaxClientRetries = s3MaxClientRetries;
        return this;
    }

    @Min(value=0L)
    public int getS3MaxErrorRetries() {
        return this.s3MaxErrorRetries;
    }

    @Config(value="hive.s3.max-error-retries")
    public HiveClientConfig setS3MaxErrorRetries(int s3MaxErrorRetries) {
        this.s3MaxErrorRetries = s3MaxErrorRetries;
        return this;
    }

    @MinDuration(value="1s")
    @NotNull
    public Duration getS3MaxBackoffTime() {
        return this.s3MaxBackoffTime;
    }

    @Config(value="hive.s3.max-backoff-time")
    public HiveClientConfig setS3MaxBackoffTime(Duration s3MaxBackoffTime) {
        this.s3MaxBackoffTime = s3MaxBackoffTime;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getS3MaxRetryTime() {
        return this.s3MaxRetryTime;
    }

    @Config(value="hive.s3.max-retry-time")
    public HiveClientConfig setS3MaxRetryTime(Duration s3MaxRetryTime) {
        this.s3MaxRetryTime = s3MaxRetryTime;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getS3ConnectTimeout() {
        return this.s3ConnectTimeout;
    }

    @Config(value="hive.s3.connect-timeout")
    public HiveClientConfig setS3ConnectTimeout(Duration s3ConnectTimeout) {
        this.s3ConnectTimeout = s3ConnectTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getS3SocketTimeout() {
        return this.s3SocketTimeout;
    }

    @Config(value="hive.s3.socket-timeout")
    public HiveClientConfig setS3SocketTimeout(Duration s3SocketTimeout) {
        this.s3SocketTimeout = s3SocketTimeout;
        return this;
    }

    @Min(value=1L)
    public int getS3MaxConnections() {
        return this.s3MaxConnections;
    }

    @Config(value="hive.s3.max-connections")
    public HiveClientConfig setS3MaxConnections(int s3MaxConnections) {
        this.s3MaxConnections = s3MaxConnections;
        return this;
    }

    @NotNull
    public File getS3StagingDirectory() {
        return this.s3StagingDirectory;
    }

    @Config(value="hive.s3.staging-directory")
    @ConfigDescription(value="Temporary directory for staging files before uploading to S3")
    public HiveClientConfig setS3StagingDirectory(File s3StagingDirectory) {
        this.s3StagingDirectory = s3StagingDirectory;
        return this;
    }

    @NotNull
    public DataSize getS3MultipartMinFileSize() {
        return this.s3MultipartMinFileSize;
    }

    @Config(value="hive.s3.multipart.min-file-size")
    @ConfigDescription(value="Minimum file size for an S3 multipart upload")
    public HiveClientConfig setS3MultipartMinFileSize(DataSize size) {
        this.s3MultipartMinFileSize = size;
        return this;
    }

    @NotNull
    public DataSize getS3MultipartMinPartSize() {
        return this.s3MultipartMinPartSize;
    }

    @Config(value="hive.s3.multipart.min-part-size")
    @ConfigDescription(value="Minimum part size for an S3 multipart upload")
    public HiveClientConfig setS3MultipartMinPartSize(DataSize size) {
        this.s3MultipartMinPartSize = size;
        return this;
    }

    @Deprecated
    public boolean isOptimizedReaderEnabled() {
        return this.optimizedReaderEnabled;
    }

    @Deprecated
    @Config(value="hive.optimized-reader.enabled")
    public HiveClientConfig setOptimizedReaderEnabled(boolean optimizedReaderEnabled) {
        this.optimizedReaderEnabled = optimizedReaderEnabled;
        return this;
    }
}

