/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SerializableNativeValue;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class HivePartition
implements ConnectorPartition {
    public static final String UNPARTITIONED_ID = "<UNPARTITIONED>";
    private final SchemaTableName tableName;
    private final TupleDomain<HiveColumnHandle> effectivePredicate;
    private final String partitionId;
    private final Map<ConnectorColumnHandle, SerializableNativeValue> keys;
    private final Optional<HiveBucketing.HiveBucket> bucket;

    public HivePartition(SchemaTableName tableName, TupleDomain<HiveColumnHandle> effectivePredicate) {
        this.tableName = (SchemaTableName)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        this.effectivePredicate = (TupleDomain)Preconditions.checkNotNull(effectivePredicate, (Object)"effectivePredicate is null");
        this.partitionId = UNPARTITIONED_ID;
        this.keys = ImmutableMap.of();
        this.bucket = Optional.absent();
    }

    public HivePartition(SchemaTableName tableName, TupleDomain<HiveColumnHandle> effectivePredicate, String partitionId, Map<ConnectorColumnHandle, SerializableNativeValue> keys, Optional<HiveBucketing.HiveBucket> bucket) {
        this.tableName = (SchemaTableName)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        this.effectivePredicate = (TupleDomain)Preconditions.checkNotNull(effectivePredicate, (Object)"effectivePredicate is null");
        this.partitionId = (String)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId is null");
        this.keys = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(keys, (Object)"keys is null")));
        this.bucket = (Optional)Preconditions.checkNotNull(bucket, (Object)"bucket number is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public TupleDomain<HiveColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public TupleDomain<ConnectorColumnHandle> getTupleDomain() {
        return TupleDomain.withNullableFixedValues(this.keys);
    }

    public Map<ConnectorColumnHandle, SerializableNativeValue> getKeys() {
        return this.keys;
    }

    public Optional<HiveBucketing.HiveBucket> getBucket() {
        return this.bucket;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HivePartition other = (HivePartition)obj;
        return Objects.equals(this.partitionId, other.partitionId);
    }

    public String toString() {
        return this.tableName + ":" + this.partitionId;
    }
}

