/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveMetastoreClient;
import com.facebook.presto.hive.HiveMetastoreClientFactory;
import com.facebook.presto.hive.shaded.org.apache.thrift.transport.TTransportException;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;

public class StaticHiveCluster
implements HiveCluster {
    private final HostAndPort address;
    private final HiveMetastoreClientFactory clientFactory;

    public StaticHiveCluster(HostAndPort address, HiveMetastoreClientFactory clientFactory) {
        Preconditions.checkNotNull((Object)address, (Object)"address is null");
        Preconditions.checkArgument((boolean)address.hasPort(), (Object)"address does not have a port");
        Preconditions.checkNotNull((Object)clientFactory, (Object)"clientFactory is null");
        this.address = address;
        this.clientFactory = clientFactory;
    }

    @Override
    public HiveMetastoreClient createMetastoreClient() {
        try {
            return this.clientFactory.create(this.address.getHostText(), this.address.getPort());
        }
        catch (TTransportException e) {
            throw new RuntimeException("Failed connecting to Hive metastore: " + this.address, e);
        }
    }
}

