/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;

public class HdfsOrcDataSource
implements OrcDataSource {
    private final FSDataInputStream inputStream;
    private final String path;
    private final long size;
    private long readTimeNanos;

    public HdfsOrcDataSource(String path, FSDataInputStream inputStream, long size) throws IOException {
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path is null");
        this.inputStream = (FSDataInputStream)Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream is null");
        this.size = size;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getSize() {
        return this.size;
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
    }

    public <K> Map<K, Slice> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        Preconditions.checkNotNull(diskRanges, (Object)"diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        DiskRange fullRange = diskRanges.values().iterator().next();
        for (DiskRange diskRange : diskRanges.values()) {
            fullRange = fullRange.span(diskRange);
        }
        byte[] buffer = new byte[fullRange.getLength()];
        this.readFully(fullRange.getOffset(), buffer);
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            int offset = Ints.checkedCast((long)(diskRange.getOffset() - fullRange.getOffset()));
            slices.put(entry.getKey(), (Object)Slices.wrappedBuffer((byte[])buffer, (int)offset, (int)diskRange.getLength()));
        }
        return slices.build();
    }

    public String toString() {
        return this.path;
    }
}

