/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.HiveBooleanParser;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NumberParser;
import com.facebook.presto.orc.BooleanVector;
import com.facebook.presto.orc.DoubleVector;
import com.facebook.presto.orc.LongVector;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.orc.SliceVector;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.LazyFixedWidthBlock;
import com.facebook.presto.spi.block.LazySliceArrayBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public class OrcPageSource
implements ConnectorPageSource {
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private final OrcRecordReader recordReader;
    private final OrcDataSource orcDataSource;
    private final List<String> columnNames;
    private final List<Type> types;
    private final boolean[] isStructuralType;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private long completedBytes;
    private int batchId;
    private boolean closed;

    public OrcPageSource(OrcRecordReader recordReader, OrcDataSource orcDataSource, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        this.recordReader = (OrcRecordReader)Preconditions.checkNotNull((Object)recordReader, (Object)"recordReader is null");
        this.orcDataSource = (OrcDataSource)Preconditions.checkNotNull((Object)orcDataSource, (Object)"orcDataSource is null");
        ImmutableMap partitionKeysByName = Maps.uniqueIndex((Iterable)((Iterable)Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null")), HivePartitionKey.nameGetter());
        int size = ((List)Preconditions.checkNotNull(columns, (Object)"columns is null")).size();
        this.isStructuralType = new boolean[size];
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            String name = column.getName();
            Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add((Object)name);
            typesBuilder.add((Object)type);
            String typeBase = column.getTypeSignature().getBase();
            this.isStructuralType[columnIndex] = "array".equals(typeBase) || "map".equals(typeBase) || "row".equals(typeBase);
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (column.isPartitionKey()) {
                int i;
                int i2;
                HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(name);
                Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"No value provided for partition key %s", (Object[])new Object[]{name});
                byte[] bytes = partitionKey.getValue().getBytes(Charsets.UTF_8);
                BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
                if (HiveUtil.isHiveNull(bytes)) {
                    for (int i3 = 0; i3 < 1024; ++i3) {
                        blockBuilder.appendNull();
                    }
                } else if (type.equals(BooleanType.BOOLEAN)) {
                    boolean value;
                    if (HiveBooleanParser.isTrue(bytes, 0, bytes.length)) {
                        value = true;
                    } else if (HiveBooleanParser.isFalse(bytes, 0, bytes.length)) {
                        value = false;
                    } else {
                        String valueString = new String(bytes, Charsets.UTF_8);
                        throw new IllegalArgumentException(String.format("Invalid partition value '%s' for BOOLEAN partition key %s", valueString, name));
                    }
                    for (i2 = 0; i2 < 1024; ++i2) {
                        BooleanType.BOOLEAN.writeBoolean(blockBuilder, value);
                    }
                } else if (type.equals(BigintType.BIGINT)) {
                    if (bytes.length == 0) {
                        throw new IllegalArgumentException(String.format("Invalid partition value '' for BIGINT partition key %s", name));
                    }
                    long value = NumberParser.parseLong(bytes, 0, bytes.length);
                    for (i = 0; i < 1024; ++i) {
                        BigintType.BIGINT.writeLong(blockBuilder, value);
                    }
                } else if (type.equals(DoubleType.DOUBLE)) {
                    if (bytes.length == 0) {
                        throw new IllegalArgumentException(String.format("Invalid partition value '' for DOUBLE partition key %s", name));
                    }
                    double value = NumberParser.parseDouble(bytes, 0, bytes.length);
                    for (i = 0; i < 1024; ++i) {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, value);
                    }
                } else if (type.equals(VarcharType.VARCHAR)) {
                    Slice value = Slices.wrappedBuffer((byte[])bytes);
                    for (i2 = 0; i2 < 1024; ++i2) {
                        VarcharType.VARCHAR.writeSlice(blockBuilder, value);
                    }
                } else if (type.equals(DateType.DATE)) {
                    long value = ISODateTimeFormat.date().withZone(DateTimeZone.UTC).parseMillis(partitionKey.getValue());
                    for (i = 0; i < 1024; ++i) {
                        DateType.DATE.writeLong(blockBuilder, value);
                    }
                } else if (type.equals(TimestampType.TIMESTAMP)) {
                    long value = HiveUtil.parseHiveTimestamp(partitionKey.getValue(), hiveStorageTimeZone);
                    for (i = 0; i < 1024; ++i) {
                        DateType.DATE.writeLong(blockBuilder, value);
                    }
                } else {
                    throw new UnsupportedOperationException("Partition key " + name + " had an unsupported column type " + type);
                }
                this.constantBlocks[columnIndex] = blockBuilder.build();
                continue;
            }
            if (recordReader.isColumnPresent(column.getHiveColumnIndex())) continue;
            BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
            for (int i = 0; i < 1024; ++i) {
                blockBuilder.appendNull();
            }
            this.constantBlocks[columnIndex] = blockBuilder.build();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
    }

    public long getTotalBytes() {
        return this.recordReader.getSplitLength();
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            int batchSize = this.recordReader.nextBatch();
            if (batchSize <= 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                Type type = this.types.get(fieldId);
                if (this.constantBlocks[fieldId] != null) {
                    blocks[fieldId] = this.constantBlocks[fieldId].getRegion(0, batchSize);
                    continue;
                }
                if (BooleanType.BOOLEAN.equals((Object)type)) {
                    blocks[fieldId] = new LazyFixedWidthBlock(BooleanType.BOOLEAN.getFixedSize(), batchSize, (LazyBlockLoader)new LazyBooleanBlockLoader(this.hiveColumnIndexes[fieldId], batchSize));
                    continue;
                }
                if (DateType.DATE.equals((Object)type)) {
                    blocks[fieldId] = new LazyFixedWidthBlock(DateType.DATE.getFixedSize(), batchSize, (LazyBlockLoader)new LazyDateBlockLoader(this.hiveColumnIndexes[fieldId], batchSize));
                    continue;
                }
                if (BigintType.BIGINT.equals((Object)type) || TimestampType.TIMESTAMP.equals((Object)type)) {
                    blocks[fieldId] = new LazyFixedWidthBlock(((FixedWidthType)type).getFixedSize(), batchSize, (LazyBlockLoader)new LazyLongBlockLoader(this.hiveColumnIndexes[fieldId], batchSize));
                    continue;
                }
                if (DoubleType.DOUBLE.equals((Object)type)) {
                    blocks[fieldId] = new LazyFixedWidthBlock(DoubleType.DOUBLE.getFixedSize(), batchSize, (LazyBlockLoader)new LazyDoubleBlockLoader(this.hiveColumnIndexes[fieldId], batchSize));
                    continue;
                }
                if (VarcharType.VARCHAR.equals((Object)type) || VarbinaryType.VARBINARY.equals((Object)type) || this.isStructuralType[fieldId]) {
                    blocks[fieldId] = new LazySliceArrayBlock(batchSize, (LazyBlockLoader)new LazySliceBlockLoader(this.hiveColumnIndexes[fieldId]));
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported column type: " + type);
            }
            Page page = new Page(batchSize, blocks);
            long newCompletedBytes = (long)((float)this.recordReader.getSplitLength() * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.recordReader.getSplitLength(), Math.max(this.completedBytes, newCompletedBytes));
            return page;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    protected void closeWithSuppression(Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable, (Object)"throwable is null");
        try {
            this.close();
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
        }
    }

    private final class LazySliceBlockLoader
    implements LazyBlockLoader<LazySliceArrayBlock> {
        private final int expectedBatchId;
        private final int hiveColumnIndex;

        public LazySliceBlockLoader(int hiveColumnIndex) {
            this.expectedBatchId = OrcPageSource.this.batchId;
            this.hiveColumnIndex = hiveColumnIndex;
        }

        public void load(LazySliceArrayBlock block) {
            Preconditions.checkState((OrcPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                SliceVector vector = new SliceVector();
                OrcPageSource.this.recordReader.readVector(this.hiveColumnIndex, (Object)vector);
                block.setValues(vector.vector);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private final class LazyDoubleBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final int expectedBatchId;
        private final int batchSize;
        private final int hiveColumnIndex;

        public LazyDoubleBlockLoader(int hiveColumnIndex, int batchSize) {
            this.expectedBatchId = OrcPageSource.this.batchId;
            this.batchSize = batchSize;
            this.hiveColumnIndex = hiveColumnIndex;
        }

        public void load(LazyFixedWidthBlock block) {
            Preconditions.checkState((OrcPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                DoubleVector vector = new DoubleVector();
                OrcPageSource.this.recordReader.readVector(this.hiveColumnIndex, (Object)vector);
                block.setNullVector(vector.isNull);
                block.setRawSlice(Slices.wrappedDoubleArray((double[])vector.vector, (int)0, (int)this.batchSize));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private final class LazyLongBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final int expectedBatchId;
        private final int batchSize;
        private final int hiveColumnIndex;

        public LazyLongBlockLoader(int hiveColumnIndex, int batchSize) {
            this.expectedBatchId = OrcPageSource.this.batchId;
            this.batchSize = batchSize;
            this.hiveColumnIndex = hiveColumnIndex;
        }

        public void load(LazyFixedWidthBlock block) {
            Preconditions.checkState((OrcPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                LongVector vector = new LongVector();
                OrcPageSource.this.recordReader.readVector(this.hiveColumnIndex, (Object)vector);
                block.setNullVector(vector.isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector.vector, (int)0, (int)this.batchSize));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private final class LazyDateBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final int expectedBatchId;
        private final int batchSize;
        private final int hiveColumnIndex;

        public LazyDateBlockLoader(int hiveColumnIndex, int batchSize) {
            this.expectedBatchId = OrcPageSource.this.batchId;
            this.batchSize = batchSize;
            this.hiveColumnIndex = hiveColumnIndex;
        }

        public void load(LazyFixedWidthBlock block) {
            Preconditions.checkState((OrcPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                LongVector vector = new LongVector();
                OrcPageSource.this.recordReader.readVector(this.hiveColumnIndex, (Object)vector);
                int i = 0;
                while (i < this.batchSize) {
                    int n = i++;
                    vector.vector[n] = vector.vector[n] * MILLIS_IN_DAY;
                }
                block.setNullVector(vector.isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector.vector, (int)0, (int)this.batchSize));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private final class LazyBooleanBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final int expectedBatchId;
        private final int batchSize;
        private final int hiveColumnIndex;

        public LazyBooleanBlockLoader(int hiveColumnIndex, int batchSize) {
            this.expectedBatchId = OrcPageSource.this.batchId;
            this.batchSize = batchSize;
            this.hiveColumnIndex = hiveColumnIndex;
        }

        public void load(LazyFixedWidthBlock block) {
            Preconditions.checkState((OrcPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                BooleanVector vector = new BooleanVector();
                OrcPageSource.this.recordReader.readVector(this.hiveColumnIndex, (Object)vector);
                block.setNullVector(vector.isNull);
                block.setRawSlice(Slices.wrappedBooleanArray((boolean[])vector.vector, (int)0, (int)this.batchSize));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

