/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.OrcPageSource;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.joda.time.DateTimeZone;

public class OrcPageSourceFactory
implements HivePageSourceFactory {
    private final TypeManager typeManager;
    private final boolean enabled;

    @Inject
    public OrcPageSourceFactory(TypeManager typeManager, HiveClientConfig config) {
        this(typeManager, config.isOptimizedReaderEnabled());
    }

    public OrcPageSourceFactory(TypeManager typeManager) {
        this(typeManager, true);
    }

    public OrcPageSourceFactory(TypeManager typeManager, boolean enabled) {
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        this.enabled = enabled;
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone) {
        if (!HiveSessionProperties.isOptimizedReaderEnabled(session, this.enabled)) {
            return Optional.absent();
        }
        Deserializer deserializer = HiveUtil.getDeserializer(schema);
        if (!(deserializer instanceof OrcSerde)) {
            return Optional.absent();
        }
        return Optional.of((Object)OrcPageSourceFactory.createOrcPageSource((MetadataReader)new OrcMetadataReader(), configuration, path, start, length, columns, partitionKeys, effectivePredicate, hiveStorageTimeZone, this.typeManager));
    }

    public static OrcPageSource createOrcPageSource(MetadataReader metadataReader, Configuration configuration, Path path, long start, long length, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        HdfsOrcDataSource orcDataSource;
        try {
            FileSystem fileSystem = path.getFileSystem(configuration);
            long size = fileSystem.getFileStatus(path).getLen();
            FSDataInputStream inputStream = fileSystem.open(path);
            orcDataSource = new HdfsOrcDataSource(path.toString(), inputStream, size);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableSet.Builder includedColumns = ImmutableSet.builder();
        ImmutableList.Builder columnReferences = ImmutableList.builder();
        for (HiveColumnHandle column : columns) {
            if (column.isPartitionKey()) continue;
            includedColumns.add((Object)column.getHiveColumnIndex());
            Type type = typeManager.getType(column.getTypeSignature());
            columnReferences.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)column, column.getHiveColumnIndex(), type));
        }
        TupleDomainOrcPredicate predicate = new TupleDomainOrcPredicate(effectivePredicate, (List)columnReferences.build());
        try {
            OrcReader reader = new OrcReader((OrcDataSource)orcDataSource, metadataReader);
            OrcRecordReader recordReader = reader.createRecordReader((Set)includedColumns.build(), (OrcPredicate)predicate, start, length, hiveStorageTimeZone);
            return new OrcPageSource(recordReader, orcDataSource, partitionKeys, columns, hiveStorageTimeZone, typeManager);
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw Throwables.propagate((Throwable)e);
        }
    }
}

