/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.orc.OrcHiveRecordCursor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.joda.time.DateTimeZone;

public class OrcRecordCursorProvider
implements HiveRecordCursorProvider {
    private final boolean enabled;

    @Inject
    public OrcRecordCursorProvider(HiveClientConfig config) {
        this(!config.isOptimizedReaderEnabled());
    }

    public OrcRecordCursorProvider() {
        this(true);
    }

    public OrcRecordCursorProvider(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Optional<HiveRecordCursor> createHiveRecordCursor(String clientId, Configuration configuration, ConnectorSession session, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        RecordReader recordReader;
        if (!this.enabled) {
            return Optional.absent();
        }
        Deserializer deserializer = HiveUtil.getDeserializer(schema);
        if (!(deserializer instanceof OrcSerde)) {
            return Optional.absent();
        }
        try {
            FileSystem fileSystem = path.getFileSystem(configuration);
            Reader reader = OrcFile.createReader((FileSystem)fileSystem, (Path)path);
            boolean[] include = OrcRecordCursorProvider.findIncludedColumns(reader.getTypes(), columns);
            recordReader = reader.rows(start, length, include);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Optional.of((Object)new OrcHiveRecordCursor(recordReader, length, schema, partitionKeys, columns, hiveStorageTimeZone, DateTimeZone.forID((String)session.getTimeZoneKey().getId()), typeManager));
    }

    private static boolean[] findIncludedColumns(List<OrcProto.Type> types, List<HiveColumnHandle> columns) {
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0, (Object)"types is empty");
        boolean[] includes = new boolean[types.size()];
        includes[0] = true;
        OrcProto.Type root = types.get(0);
        List included = Lists.transform(columns, HiveColumnHandle.hiveColumnIndexGetter());
        for (int i = 0; i < root.getSubtypesCount(); ++i) {
            if (!included.contains(i)) continue;
            OrcRecordCursorProvider.includeColumnRecursive(types, includes, root.getSubtypes(i));
        }
        for (boolean include : includes) {
            if (include) continue;
            return includes;
        }
        return null;
    }

    private static void includeColumnRecursive(List<OrcProto.Type> types, boolean[] result, int typeId) {
        result[typeId] = true;
        OrcProto.Type type = types.get(typeId);
        int children = type.getSubtypesCount();
        for (int i = 0; i < children; ++i) {
            OrcRecordCursorProvider.includeColumnRecursive(types, result, type.getSubtypes(i));
        }
    }
}

