/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rcfile;

import com.facebook.presto.hive.HiveBooleanParser;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NumberParser;
import com.facebook.presto.hive.rcfile.RcFileBlockLoader;
import com.facebook.presto.hive.rcfile.RcFilePageSource;
import com.facebook.presto.hive.shaded.org.apache.commons.codec.binary.Base64;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.LazyFixedWidthBlock;
import com.facebook.presto.spi.block.LazySliceArrayBlock;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class RcTextBlockLoader
implements RcFileBlockLoader {
    private static final DateTimeFormatter DATE_PARSER = ISODateTimeFormat.date().withZoneUTC();
    private final DateTimeZone hiveStorageTimeZone;
    private final DateTimeZone sessionTimeZone;

    public RcTextBlockLoader(DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone) {
        this.hiveStorageTimeZone = hiveStorageTimeZone;
        this.sessionTimeZone = sessionTimeZone;
    }

    @Override
    public LazyBlockLoader<LazyFixedWidthBlock> fixedWidthBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId, HiveType hiveType) {
        if (HiveType.HIVE_BOOLEAN.equals(hiveType)) {
            return new LazyBooleanBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_BYTE.equals(hiveType) || HiveType.HIVE_SHORT.equals(hiveType) || HiveType.HIVE_INT.equals(hiveType) || HiveType.HIVE_LONG.equals(hiveType)) {
            return new LazyLongBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_DATE.equals(hiveType)) {
            return new LazyDateBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_TIMESTAMP.equals(hiveType)) {
            return new LazyTimestampBlockLoader(batch, fieldId, this.hiveStorageTimeZone);
        }
        if (HiveType.HIVE_FLOAT.equals(hiveType) || HiveType.HIVE_DOUBLE.equals(hiveType)) {
            return new LazyDoubleBlockLoader(batch, fieldId);
        }
        throw new UnsupportedOperationException("Unsupported column type: " + hiveType);
    }

    @Override
    public LazyBlockLoader<LazySliceArrayBlock> variableWidthBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId, HiveType hiveType, ObjectInspector fieldInspector) {
        if (HiveType.HIVE_STRING.equals(hiveType)) {
            return new LazyStringBlockLoader(batch, fieldId);
        }
        if (HiveType.HIVE_BINARY.equals(hiveType)) {
            return new LazyBinaryBlockLoader(batch, fieldId);
        }
        if (HiveUtil.isStructuralType(hiveType)) {
            return new LazyJsonSliceBlockLoader(batch, fieldId, fieldInspector, this.sessionTimeZone);
        }
        throw new UnsupportedOperationException("Unsupported column type: " + hiveType);
    }

    private static boolean isNull(byte[] bytes, int start, int length) {
        return length == "\\N".length() && bytes[start] == 92 && bytes[start + 1] == 78;
    }

    private static final class LazyJsonSliceBlockLoader
    implements LazyBlockLoader<LazySliceArrayBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private final ObjectInspector fieldInspector;
        private final DateTimeZone sessionTimeZone;
        private boolean loaded;

        private LazyJsonSliceBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId, ObjectInspector fieldInspector, DateTimeZone sessionTimeZone) {
            this.batch = batch;
            this.fieldId = fieldId;
            this.fieldInspector = fieldInspector;
            this.sessionTimeZone = sessionTimeZone;
        }

        public void load(LazySliceArrayBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                Slice[] vector = new Slice[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    int length;
                    int start;
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    if (RcTextBlockLoader.isNull(bytes, start = writable.getStart(), length = writable.getLength())) continue;
                    LazyObject lazyObject = LazyFactory.createLazyObject((ObjectInspector)this.fieldInspector);
                    ByteArrayRef byteArrayRef = new ByteArrayRef();
                    byteArrayRef.setData(bytes);
                    lazyObject.init(byteArrayRef, start, length);
                    vector[i] = Slices.wrappedBuffer((byte[])SerDeUtils.getJsonBytes(this.sessionTimeZone, lazyObject.getObject(), this.fieldInspector));
                }
                block.setValues(vector);
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyBinaryBlockLoader
    implements LazyBlockLoader<LazySliceArrayBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyBinaryBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazySliceArrayBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                Slice[] vector = new Slice[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    int length;
                    int start;
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    if (RcTextBlockLoader.isNull(bytes, start = writable.getStart(), length = writable.getLength())) continue;
                    byte[] data = Arrays.copyOfRange(bytes, start, start + length);
                    vector[i] = Slices.wrappedBuffer((byte[])Base64.decodeBase64((byte[])data));
                }
                block.setValues(vector);
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyStringBlockLoader
    implements LazyBlockLoader<LazySliceArrayBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyStringBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazySliceArrayBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                Slice[] vector = new Slice[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    int length;
                    int start;
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    if (RcTextBlockLoader.isNull(bytes, start = writable.getStart(), length = writable.getLength())) continue;
                    vector[i] = Slices.wrappedBuffer((byte[])Arrays.copyOfRange(bytes, start, start + length));
                }
                block.setValues(vector);
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyDoubleBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyDoubleBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                double[] vector = new double[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    int start = writable.getStart();
                    int length = writable.getLength();
                    if (length == 0 || RcTextBlockLoader.isNull(bytes, start, length)) {
                        isNull[i] = true;
                        continue;
                    }
                    vector[i] = NumberParser.parseDouble(bytes, start, length);
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedDoubleArray((double[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyTimestampBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private final DateTimeZone hiveStorageTimeZone;
        private boolean loaded;

        private LazyTimestampBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId, DateTimeZone hiveStorageTimeZone) {
            this.batch = batch;
            this.fieldId = fieldId;
            this.hiveStorageTimeZone = hiveStorageTimeZone;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                long[] vector = new long[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    int start = writable.getStart();
                    int length = writable.getLength();
                    if (length == 0 || RcTextBlockLoader.isNull(bytes, start, length)) {
                        isNull[i] = true;
                        continue;
                    }
                    String value = new String(bytes, start, length);
                    vector[i] = HiveUtil.parseHiveTimestamp(value, this.hiveStorageTimeZone);
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyDateBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyDateBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int positionCount = block.getPositionCount();
                boolean[] isNull = new boolean[positionCount];
                long[] vector = new long[positionCount];
                for (int i = 0; i < positionCount; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    int start = writable.getStart();
                    int length = writable.getLength();
                    if (length == 0 || RcTextBlockLoader.isNull(bytes, start, length)) {
                        isNull[i] = true;
                        continue;
                    }
                    String value = new String(bytes, start, length);
                    vector[i] = DATE_PARSER.parseMillis(value);
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyLongBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        private LazyLongBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int batchSize = block.getPositionCount();
                boolean[] isNull = new boolean[batchSize];
                long[] vector = new long[batchSize];
                for (int i = 0; i < batchSize; ++i) {
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    int start = writable.getStart();
                    int length = writable.getLength();
                    if (length == 0 || RcTextBlockLoader.isNull(bytes, start, length)) {
                        isNull[i] = true;
                        continue;
                    }
                    vector[i] = NumberParser.parseLong(bytes, start, length);
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedLongArray((long[])vector));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class LazyBooleanBlockLoader
    implements LazyBlockLoader<LazyFixedWidthBlock> {
        private final RcFilePageSource.RcFileColumnsBatch batch;
        private final int fieldId;
        private boolean loaded;

        public LazyBooleanBlockLoader(RcFilePageSource.RcFileColumnsBatch batch, int fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public void load(LazyFixedWidthBlock block) {
            if (this.loaded) {
                return;
            }
            try {
                BytesRefArrayWritable columnBatch = this.batch.getColumn(this.fieldId);
                int positionInBatch = this.batch.getPositionInBatch();
                int positionCount = block.getPositionCount();
                boolean[] isNull = new boolean[positionCount];
                boolean[] vector = new boolean[positionCount];
                for (int i = 0; i < positionCount; ++i) {
                    int length;
                    int start;
                    BytesRefWritable writable = columnBatch.unCheckedGet(i + positionInBatch);
                    byte[] bytes = writable.getData();
                    if (HiveBooleanParser.isTrue(bytes, start = writable.getStart(), length = writable.getLength())) {
                        vector[i] = true;
                        continue;
                    }
                    if (HiveBooleanParser.isFalse(bytes, start, length)) {
                        vector[i] = false;
                        continue;
                    }
                    isNull[i] = true;
                }
                block.setNullVector(isNull);
                block.setRawSlice(Slices.wrappedBooleanArray((boolean[])vector, (int)0, (int)positionCount));
                this.loaded = true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

