/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.Types;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class SerDeUtils {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);

    private SerDeUtils() {
    }

    public static byte[] getJsonBytes(DateTimeZone sessionTimeZone, Object object, ObjectInspector objectInspector) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)out);){
            SerDeUtils.serializeObject(sessionTimeZone, generator, object, objectInspector, null);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return out.toByteArray();
    }

    private static void serializeObject(DateTimeZone sessionTimeZone, JsonGenerator generator, Object object, ObjectInspector inspector, JsonContext context) throws IOException {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                SerDeUtils.serializePrimitive(sessionTimeZone, generator, object, (PrimitiveObjectInspector)inspector, context);
                return;
            }
            case LIST: {
                SerDeUtils.serializeList(sessionTimeZone, generator, object, (ListObjectInspector)inspector, context);
                return;
            }
            case MAP: {
                SerDeUtils.serializeMap(sessionTimeZone, generator, object, (MapObjectInspector)inspector, context);
                return;
            }
            case STRUCT: {
                SerDeUtils.serializeStruct(sessionTimeZone, generator, object, (StructObjectInspector)inspector, context);
                return;
            }
        }
        throw new RuntimeException("Unknown object inspector category: " + inspector.getCategory());
    }

    private static void serializePrimitive(DateTimeZone sessionTimeZone, JsonGenerator generator, Object object, PrimitiveObjectInspector inspector, JsonContext context) throws IOException {
        if (object == null) {
            generator.writeNull();
            return;
        }
        switch (inspector.getPrimitiveCategory()) {
            case BOOLEAN: {
                generator.writeBoolean(((BooleanObjectInspector)inspector).get(object));
                return;
            }
            case BYTE: {
                generator.writeNumber((short)((ByteObjectInspector)inspector).get(object));
                return;
            }
            case SHORT: {
                generator.writeNumber(((ShortObjectInspector)inspector).get(object));
                return;
            }
            case INT: {
                generator.writeNumber(((IntObjectInspector)inspector).get(object));
                return;
            }
            case LONG: {
                generator.writeNumber(((LongObjectInspector)inspector).get(object));
                return;
            }
            case FLOAT: {
                generator.writeNumber(((FloatObjectInspector)inspector).get(object));
                return;
            }
            case DOUBLE: {
                generator.writeNumber(((DoubleObjectInspector)inspector).get(object));
                return;
            }
            case STRING: {
                generator.writeString(((StringObjectInspector)inspector).getPrimitiveJavaObject(object));
                return;
            }
            case DATE: {
                if (context == JsonContext.JSON_STACK) {
                    generator.writeNumber(SerDeUtils.formatDateAsLong(object, (DateObjectInspector)inspector));
                } else {
                    generator.writeString(SerDeUtils.formatDate(object, (DateObjectInspector)inspector));
                }
                return;
            }
            case TIMESTAMP: {
                if (context == JsonContext.JSON_STACK) {
                    generator.writeNumber(SerDeUtils.formatTimestampAsLong(object, (TimestampObjectInspector)inspector));
                } else {
                    generator.writeString(SerDeUtils.formatTimestamp(sessionTimeZone, object, (TimestampObjectInspector)inspector));
                }
                return;
            }
            case BINARY: {
                generator.writeBinary(((BinaryObjectInspector)inspector).getPrimitiveJavaObject(object));
                return;
            }
        }
        throw new RuntimeException("Unknown primitive type: " + inspector.getPrimitiveCategory());
    }

    private static void serializeList(DateTimeZone sessionTimeZone, JsonGenerator generator, Object object, ListObjectInspector inspector, JsonContext context) throws IOException {
        List list = inspector.getList(object);
        if (list == null) {
            generator.writeNull();
            return;
        }
        ObjectInspector elementInspector = inspector.getListElementObjectInspector();
        generator.writeStartArray();
        for (Object element : list) {
            SerDeUtils.serializeObject(sessionTimeZone, generator, element, elementInspector, context == null ? JsonContext.JSON_STACK : context);
        }
        generator.writeEndArray();
    }

    private static void serializeMap(DateTimeZone sessionTimeZone, JsonGenerator generator, Object object, MapObjectInspector inspector, JsonContext context) throws IOException {
        Map map = inspector.getMap(object);
        if (map == null) {
            generator.writeNull();
            return;
        }
        PrimitiveObjectInspector keyInspector = Types.checkType(inspector.getMapKeyObjectInspector(), PrimitiveObjectInspector.class, "map key inspector");
        ObjectInspector valueInspector = inspector.getMapValueObjectInspector();
        generator.writeStartObject();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            generator.writeFieldName(SerDeUtils.getPrimitiveAsString(sessionTimeZone, entry.getKey(), keyInspector, context == null ? JsonContext.JSON_STACK : context));
            SerDeUtils.serializeObject(sessionTimeZone, generator, entry.getValue(), valueInspector, context == null ? JsonContext.JSON_STACK : context);
        }
        generator.writeEndObject();
    }

    private static void serializeStruct(DateTimeZone sessionTimeZone, JsonGenerator generator, Object object, StructObjectInspector inspector, JsonContext context) throws IOException {
        if (object == null) {
            generator.writeNull();
            return;
        }
        generator.writeStartArray();
        for (StructField field : inspector.getAllStructFieldRefs()) {
            SerDeUtils.serializeObject(sessionTimeZone, generator, inspector.getStructFieldData(object, field), field.getFieldObjectInspector(), JsonContext.JSON_STACK);
        }
        generator.writeEndArray();
    }

    private static String getPrimitiveAsString(DateTimeZone sessionTimeZone, Object object, PrimitiveObjectInspector inspector, JsonContext context) {
        switch (inspector.getPrimitiveCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: {
                return String.valueOf(inspector.getPrimitiveJavaObject(object));
            }
            case DATE: {
                if (context == JsonContext.JSON_STACK) {
                    return String.valueOf(SerDeUtils.formatDateAsLong(object, (DateObjectInspector)inspector));
                }
                return SerDeUtils.formatDate(object, (DateObjectInspector)inspector);
            }
            case TIMESTAMP: {
                if (context == JsonContext.JSON_STACK) {
                    return String.valueOf(SerDeUtils.formatTimestampAsLong(object, (TimestampObjectInspector)inspector));
                }
                return SerDeUtils.formatTimestamp(sessionTimeZone, object, (TimestampObjectInspector)inspector);
            }
            case BINARY: {
                BytesWritable writable = ((BinaryObjectInspector)inspector).getPrimitiveWritableObject(object);
                return Base64Variants.getDefaultVariant().encode(Arrays.copyOf(writable.getBytes(), writable.getLength()));
            }
        }
        throw new RuntimeException("Unknown primitive type: " + inspector.getPrimitiveCategory());
    }

    private static String formatDate(Object object, DateObjectInspector inspector) {
        if (object instanceof DateWritable) {
            int days = ((DateWritable)object).getDays();
            return DATE_FORMATTER.withZone(DateTimeZone.UTC).print((long)days * MILLIS_IN_DAY);
        }
        Date date = inspector.getPrimitiveJavaObject(object);
        long storageTime = date.getTime();
        long utcMillis = storageTime + (long)DateTimeZone.getDefault().getOffset(storageTime);
        return DATE_FORMATTER.withZone(DateTimeZone.UTC).print(utcMillis);
    }

    private static long formatDateAsLong(Object object, DateObjectInspector inspector) {
        if (object instanceof DateWritable) {
            int days = ((DateWritable)object).getDays();
            return (long)days * MILLIS_IN_DAY;
        }
        Date date = inspector.getPrimitiveJavaObject(object);
        return date.getTime() - (long)(date.getTimezoneOffset() * 60 * 1000);
    }

    private static long formatTimestampAsLong(Object object, TimestampObjectInspector inspector) {
        Timestamp timestamp = SerDeUtils.getTimestamp(object, inspector);
        return timestamp.getTime();
    }

    private static String formatTimestamp(DateTimeZone sessionTimeZone, Object object, TimestampObjectInspector inspector) {
        Timestamp timestamp = SerDeUtils.getTimestamp(object, inspector);
        return TIMESTAMP_FORMATTER.withZone(sessionTimeZone).print(timestamp.getTime());
    }

    private static Timestamp getTimestamp(Object object, TimestampObjectInspector inspector) {
        if (object instanceof TimestampWritable) {
            return ((TimestampWritable)object).getTimestamp();
        }
        return inspector.getPrimitiveJavaObject(object);
    }

    public static enum JsonContext {
        JSON_STACK,
        JSON;

    }
}

