/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonMapKeyReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public class LongDirectJsonReader
implements JsonMapKeyReader {
    private final StreamDescriptor streamDescriptor;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private LongStream dataStream;

    public LongDirectJsonReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
        generator.writeNumber(this.dataStream.next());
    }

    @Override
    public String nextValueAsMapKey() throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            return null;
        }
        OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
        return String.valueOf(this.dataStream.next());
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize > 0) {
            OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
            this.dataStream.skip(skipSize);
        }
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.dataStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.dataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class).openStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

