/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.hive.orc.OrcOutputFormat;
import com.facebook.hive.orc.OrcSerde;
import io.airlift.units.DataSize;
import java.util.Objects;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.hcatalog.data.JsonSerDe;

public enum HiveStorageFormat {
    ORC(org.apache.hadoop.hive.ql.io.orc.OrcSerde.class.getName(), OrcInputFormat.class.getName(), org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat.class.getName(), new DataSize(256.0, DataSize.Unit.MEGABYTE)),
    DWRF(OrcSerde.class.getName(), com.facebook.hive.orc.OrcInputFormat.class.getName(), OrcOutputFormat.class.getName(), new DataSize(256.0, DataSize.Unit.MEGABYTE)),
    PARQUET(ParquetHiveSerDe.class.getName(), MapredParquetInputFormat.class.getName(), MapredParquetOutputFormat.class.getName(), new DataSize(128.0, DataSize.Unit.MEGABYTE)),
    AVRO(AvroSerDe.class.getName(), AvroContainerInputFormat.class.getName(), AvroContainerOutputFormat.class.getName(), new DataSize(64.0, DataSize.Unit.MEGABYTE)),
    RCBINARY(LazyBinaryColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    RCTEXT(ColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    SEQUENCEFILE(LazySimpleSerDe.class.getName(), SequenceFileInputFormat.class.getName(), HiveSequenceFileOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    JSON(JsonSerDe.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    TEXTFILE(LazySimpleSerDe.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName(), new DataSize(8.0, DataSize.Unit.MEGABYTE)),
    PAGEFILE("", "PageInputFormat", "PageOutputFormat", new DataSize(0.0, DataSize.Unit.MEGABYTE));

    private final String serde;
    private final String inputFormat;
    private final String outputFormat;
    private final DataSize estimatedWriterSystemMemoryUsage;

    private HiveStorageFormat(String serde, String inputFormat, String outputFormat, DataSize estimatedWriterSystemMemoryUsage) {
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat is null");
        this.estimatedWriterSystemMemoryUsage = Objects.requireNonNull(estimatedWriterSystemMemoryUsage, "estimatedWriterSystemMemoryUsage is null");
    }

    public String getSerDe() {
        return this.serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public DataSize getEstimatedWriterSystemMemoryUsage() {
        return this.estimatedWriterSystemMemoryUsage;
    }
}

