/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.ForCachingHiveMetastore;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePartitionName;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.HiveTableName;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionFilter;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.UserTableKey;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingHiveMetastore
implements ExtendedHiveMetastore {
    protected final ExtendedHiveMetastore delegate;
    private final LoadingCache<String, Optional<Database>> databaseCache;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<HiveTableName, Optional<Table>> tableCache;
    private final LoadingCache<String, Optional<List<String>>> tableNamesCache;
    private final LoadingCache<HiveTableName, PartitionStatistics> tableStatisticsCache;
    private final LoadingCache<HivePartitionName, PartitionStatistics> partitionStatisticsCache;
    private final LoadingCache<String, Optional<List<String>>> viewNamesCache;
    private final LoadingCache<HivePartitionName, Optional<Partition>> partitionCache;
    private final LoadingCache<PartitionFilter, List<String>> partitionFilterCache;
    private final LoadingCache<HiveTableName, Optional<List<String>>> partitionNamesCache;
    private final LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final LoadingCache<String, Set<String>> rolesCache;
    private final LoadingCache<PrestoPrincipal, Set<RoleGrant>> roleGrantsCache;

    @Inject
    public CachingHiveMetastore(@ForCachingHiveMetastore ExtendedHiveMetastore delegate, @ForCachingHiveMetastore ExecutorService executor, MetastoreClientConfig metastoreClientConfig) {
        this(delegate, executor, metastoreClientConfig.getMetastoreCacheTtl(), metastoreClientConfig.getMetastoreRefreshInterval(), metastoreClientConfig.getMetastoreCacheMaximumSize());
    }

    public CachingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, Duration cacheTtl, Duration refreshInterval, long maximumSize) {
        this(delegate, executor, OptionalLong.of(cacheTtl.toMillis()), refreshInterval.toMillis() >= cacheTtl.toMillis() ? OptionalLong.empty() : OptionalLong.of(refreshInterval.toMillis()), maximumSize);
    }

    public static CachingHiveMetastore memoizeMetastore(ExtendedHiveMetastore delegate, long maximumSize) {
        return new CachingHiveMetastore(delegate, (ExecutorService)MoreExecutors.newDirectExecutorService(), OptionalLong.empty(), OptionalLong.empty(), maximumSize);
    }

    private CachingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, OptionalLong expiresAfterWriteMillis, OptionalLong refreshMills, long maximumSize) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(executor, "executor is null");
        this.databaseNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllDatabases), (Executor)executor));
        this.databaseCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadDatabase), (Executor)executor));
        this.tableNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllTables), (Executor)executor));
        this.tableStatisticsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<HiveTableName, PartitionStatistics>(){

            public PartitionStatistics load(HiveTableName key) {
                return CachingHiveMetastore.this.loadTableColumnStatistics(key);
            }
        }, (Executor)executor));
        this.partitionStatisticsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<HivePartitionName, PartitionStatistics>(){

            public PartitionStatistics load(HivePartitionName key) {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(key);
            }

            public Map<HivePartitionName, PartitionStatistics> loadAll(Iterable<? extends HivePartitionName> keys) {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(keys);
            }
        }, (Executor)executor));
        this.tableCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTable), (Executor)executor));
        this.viewNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllViews), (Executor)executor));
        this.partitionNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadPartitionNames), (Executor)executor));
        this.partitionFilterCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadPartitionNamesByFilter), (Executor)executor));
        this.partitionCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<HivePartitionName, Optional<Partition>>(){

            public Optional<Partition> load(HivePartitionName partitionName) {
                return CachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            public Map<HivePartitionName, Optional<Partition>> loadAll(Iterable<? extends HivePartitionName> partitionNames) {
                return CachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        }, (Executor)executor));
        this.tablePrivilegesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(key -> this.loadTablePrivileges(key.getDatabase(), key.getTable(), key.getPrincipal())), (Executor)executor));
        this.rolesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(() -> this.loadRoles()), (Executor)executor));
        this.roleGrantsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadRoleGrants), (Executor)executor));
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.tablePrivilegesCache.invalidateAll();
        this.tableStatisticsCache.invalidateAll();
        this.partitionStatisticsCache.invalidateAll();
        this.rolesCache.invalidateAll();
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private static <K, V> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return CachingHiveMetastore.get(this.databaseCache, databaseName);
    }

    private Optional<Database> loadDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "");
    }

    private List<String> loadAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.tableCache, HiveTableName.hiveTableName(databaseName, tableName));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    private Optional<Table> loadTable(HiveTableName hiveTableName) {
        return this.delegate.getTable(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
    }

    @Override
    public PartitionStatistics getTableStatistics(String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.tableStatisticsCache, HiveTableName.hiveTableName(databaseName, tableName));
    }

    private PartitionStatistics loadTableColumnStatistics(HiveTableName hiveTableName) {
        return this.delegate.getTableStatistics(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        List partitions = (List)partitionNames.stream().map(partitionName -> HivePartitionName.hivePartitionName(databaseName, tableName, partitionName)).collect(ImmutableList.toImmutableList());
        Map<HivePartitionName, PartitionStatistics> statistics = CachingHiveMetastore.getAll(this.partitionStatisticsCache, partitions);
        return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)entry.getKey()).getPartitionName().get(), Map.Entry::getValue));
    }

    private PartitionStatistics loadPartitionColumnStatistics(HivePartitionName partition) {
        String partitionName = partition.getPartitionName().get();
        Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(partition.getHiveTableName().getDatabaseName(), partition.getHiveTableName().getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName));
        if (!partitionStatistics.containsKey(partitionName)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partition.getPartitionName());
        }
        return partitionStatistics.get(partitionName);
    }

    private Map<HivePartitionName, PartitionStatistics> loadPartitionColumnStatistics(Iterable<? extends HivePartitionName> keys) {
        SetMultimap tablePartitions = (SetMultimap)Streams.stream(keys).collect(ImmutableSetMultimap.toImmutableSetMultimap(HivePartitionName::getHiveTableName, key -> key));
        ImmutableMap.Builder result = ImmutableMap.builder();
        tablePartitions.keySet().forEach(table -> {
            Set partitionNames = (Set)tablePartitions.get(table).stream().map(partitionName -> partitionName.getPartitionName().get()).collect(ImmutableSet.toImmutableSet());
            Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(table.getDatabaseName(), table.getTableName(), partitionNames);
            for (String partitionName2 : partitionNames) {
                if (!partitionStatistics.containsKey(partitionName2)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partitionName2);
                }
                result.put((Object)HivePartitionName.hivePartitionName(table, partitionName2), (Object)partitionStatistics.get(partitionName2));
            }
        });
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStatistics(String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        try {
            this.delegate.updateTableStatistics(databaseName, tableName, update);
        }
        finally {
            this.tableStatisticsCache.invalidate((Object)HiveTableName.hiveTableName(databaseName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionStatistics(String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        try {
            this.delegate.updatePartitionStatistics(databaseName, tableName, partitionName, update);
        }
        finally {
            this.partitionStatisticsCache.invalidate((Object)HivePartitionName.hivePartitionName(databaseName, tableName, partitionName));
        }
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName);
    }

    private Optional<List<String>> loadAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        return CachingHiveMetastore.get(this.viewNamesCache, databaseName);
    }

    private Optional<List<String>> loadAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(Database database) {
        try {
            this.delegate.createDatabase(database);
        }
        finally {
            this.invalidateDatabase(database.getDatabaseName());
        }
    }

    @Override
    public void dropDatabase(String databaseName) {
        try {
            this.delegate.dropDatabase(databaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            this.delegate.renameDatabase(databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
            this.invalidateDatabase(newDatabaseName);
        }
    }

    protected void invalidateDatabase(String databaseName) {
        this.databaseCache.invalidate((Object)databaseName);
        this.databaseNamesCache.invalidateAll();
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.createTable(table, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        try {
            this.delegate.dropTable(databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        try {
            this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        try {
            this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        try {
            this.delegate.dropColumn(databaseName, tableName, columnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    protected void invalidateTable(String databaseName, String tableName) {
        this.tableCache.invalidate((Object)HiveTableName.hiveTableName(databaseName, tableName));
        this.tableNamesCache.invalidate((Object)databaseName);
        this.viewNamesCache.invalidate((Object)databaseName);
        this.tablePrivilegesCache.asMap().keySet().stream().filter(userTableKey -> userTableKey.matches(databaseName, tableName)).forEach(arg_0 -> this.tablePrivilegesCache.invalidate(arg_0));
        this.tableStatisticsCache.invalidate((Object)HiveTableName.hiveTableName(databaseName, tableName));
        this.invalidatePartitionCache(databaseName, tableName);
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        HivePartitionName name = HivePartitionName.hivePartitionName(databaseName, tableName, partitionValues);
        return CachingHiveMetastore.get(this.partitionCache, name);
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.partitionNamesCache, HiveTableName.hiveTableName(databaseName, tableName));
    }

    private Optional<List<String>> loadPartitionNames(HiveTableName hiveTableName) {
        return this.delegate.getPartitionNames(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
    }

    @Override
    public List<String> getPartitionNamesByFilter(String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        return CachingHiveMetastore.get(this.partitionFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, partitionPredicates));
    }

    private List<String> loadPartitionNamesByFilter(PartitionFilter partitionFilter) {
        return this.delegate.getPartitionNamesByFilter(partitionFilter.getHiveTableName().getDatabaseName(), partitionFilter.getHiveTableName().getTableName(), partitionFilter.getPartitionPredicates());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Iterable names = Iterables.transform(partitionNames, name -> HivePartitionName.hivePartitionName(databaseName, tableName, name));
        Map<HivePartitionName, Optional<Partition>> all = CachingHiveMetastore.getAll(this.partitionCache, names);
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        for (Map.Entry<HivePartitionName, Optional<Partition>> entry : all.entrySet()) {
            partitionsByName.put((Object)entry.getKey().getPartitionName().get(), entry.getValue());
        }
        return partitionsByName.build();
    }

    private Optional<Partition> loadPartitionByName(HivePartitionName partitionName) {
        return this.delegate.getPartition(partitionName.getHiveTableName().getDatabaseName(), partitionName.getHiveTableName().getTableName(), partitionName.getPartitionValues());
    }

    private Map<HivePartitionName, Optional<Partition>> loadPartitionsByNames(Iterable<? extends HivePartitionName> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        HivePartitionName firstPartition = (HivePartitionName)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = firstPartition.getHiveTableName();
        String databaseName = hiveTableName.getDatabaseName();
        String tableName = hiveTableName.getTableName();
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (HivePartitionName hivePartitionName : partitionNames) {
            Preconditions.checkArgument((boolean)hivePartitionName.getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object)hiveTableName, (Object)hivePartitionName.getHiveTableName());
            partitionsToFetch.add(hivePartitionName.getPartitionName().get());
        }
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        Map<String, Optional<Partition>> map = this.delegate.getPartitionsByNames(databaseName, tableName, partitionsToFetch);
        for (Map.Entry<String, Optional<Partition>> entry : map.entrySet()) {
            partitions.put((Object)HivePartitionName.hivePartitionName(hiveTableName, entry.getKey()), entry.getValue());
        }
        return partitions.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            this.delegate.addPartitions(databaseName, tableName, partitions);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            this.delegate.alterPartition(databaseName, tableName, partition);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.delegate.createRole(role, grantor);
        }
        finally {
            this.rolesCache.invalidateAll();
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.delegate.dropRole(role);
        }
        finally {
            this.rolesCache.invalidateAll();
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<String> listRoles() {
        return CachingHiveMetastore.get(this.rolesCache, "");
    }

    private Set<String> loadRoles() {
        return this.delegate.listRoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRoles(Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        try {
            this.delegate.grantRoles(roles, grantees, withAdminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRoles(Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        try {
            this.delegate.revokeRoles(roles, grantees, adminOptionFor, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(PrestoPrincipal principal) {
        return CachingHiveMetastore.get(this.roleGrantsCache, principal);
    }

    private Set<RoleGrant> loadRoleGrants(PrestoPrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    private void invalidatePartitionCache(String databaseName, String tableName) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        this.partitionNamesCache.invalidate((Object)hiveTableName);
        this.partitionCache.asMap().keySet().stream().filter(partitionName -> partitionName.getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionCache.invalidate(arg_0));
        this.partitionFilterCache.asMap().keySet().stream().filter(partitionFilter -> partitionFilter.getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionFilterCache.invalidate(arg_0));
        this.partitionStatisticsCache.asMap().keySet().stream().filter(partitionFilter -> partitionFilter.getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionStatisticsCache.invalidate(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePrivileges(String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.delegate.grantTablePrivileges(databaseName, tableName, grantee, privileges);
        }
        finally {
            this.tablePrivilegesCache.invalidate((Object)new UserTableKey(grantee, databaseName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.delegate.revokeTablePrivileges(databaseName, tableName, grantee, privileges);
        }
        finally {
            this.tablePrivilegesCache.invalidate((Object)new UserTableKey(grantee, databaseName, tableName));
        }
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, PrestoPrincipal principal) {
        return CachingHiveMetastore.get(this.tablePrivilegesCache, new UserTableKey(principal, databaseName, tableName));
    }

    public Set<HivePrivilegeInfo> loadTablePrivileges(String databaseName, String tableName, PrestoPrincipal principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, principal);
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, long maximumSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder = cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        if (refreshMillis.isPresent() && (!expiresAfterWriteMillis.isPresent() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder = cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder = cacheBuilder.maximumSize(maximumSize);
        return cacheBuilder;
    }
}

