/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HiveTableName {
    private final String databaseName;
    private final String tableName;

    @JsonCreator
    public HiveTableName(@JsonProperty(value="databaseName") String databaseName, @JsonProperty(value="tableName") String tableName) {
        this.databaseName = databaseName;
        this.tableName = tableName;
    }

    public static HiveTableName hiveTableName(String databaseName, String tableName) {
        return new HiveTableName(databaseName, tableName);
    }

    @JsonProperty
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("tableName", (Object)this.tableName).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableName other = (HiveTableName)o;
        return Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.tableName, other.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tableName);
    }
}

