/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hive.metastore.api.FieldSchema;

public class BridgingHiveMetastore
implements ExtendedHiveMetastore {
    private final HiveMetastore delegate;

    @Inject
    public BridgingHiveMetastore(HiveMetastore delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName).map(ThriftMetastoreUtil::fromMetastoreApiDatabase);
    }

    @Override
    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return this.delegate.getTable(databaseName, tableName).map(table -> {
            if (ThriftMetastoreUtil.isAvroTableWithSchemaSet(table)) {
                return ThriftMetastoreUtil.fromMetastoreApiTable(table, this.delegate.getFields(databaseName, tableName).get());
            }
            return ThriftMetastoreUtil.fromMetastoreApiTable(table);
        });
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    @Override
    public PartitionStatistics getTableStatistics(String databaseName, String tableName) {
        return this.delegate.getTableStatistics(databaseName, tableName);
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        return this.delegate.getPartitionStatistics(databaseName, tableName, partitionNames);
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.delegate.updateTableStatistics(databaseName, tableName, update);
    }

    @Override
    public void updatePartitionStatistics(String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.delegate.updatePartitionStatistics(databaseName, tableName, partitionName, update);
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(Database database) {
        this.delegate.createDatabase(ThriftMetastoreUtil.toMetastoreApiDatabase(database));
    }

    @Override
    public void dropDatabase(String databaseName) {
        this.delegate.dropDatabase(databaseName);
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        org.apache.hadoop.hive.metastore.api.Database database = this.delegate.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
        database.setName(newDatabaseName);
        this.delegate.alterDatabase(databaseName, database);
        this.delegate.getDatabase(databaseName).ifPresent(newDatabase -> {
            if (newDatabase.getName().equals(databaseName)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive metastore does not support renaming schemas");
            }
        });
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        Preconditions.checkArgument((!table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE) ? 1 : 0) != 0, (Object)"temporary tables must never be stored in the metastore");
        this.delegate.createTable(ThriftMetastoreUtil.toMetastoreApiTable(table, principalPrivileges));
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.delegate.dropTable(databaseName, tableName, deleteData);
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        Preconditions.checkArgument((!newTable.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE) ? 1 : 0) != 0, (Object)"temporary tables must never be stored in the metastore");
        this.alterTable(databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiTable(newTable, principalPrivileges));
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(databaseName, tableName);
        if (!source.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        table.setDbName(newDatabaseName);
        table.setTableName(newTableName);
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(databaseName, tableName);
        if (!source.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        table.getSd().getCols().add(new FieldSchema(columnName, columnType.getHiveTypeName().toString(), columnComment));
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(databaseName, tableName);
        if (!source.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        for (FieldSchema fieldSchema : table.getPartitionKeys()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        for (FieldSchema fieldSchema : table.getSd().getCols()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            fieldSchema.setName(newColumnName);
        }
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
        org.apache.hadoop.hive.metastore.api.Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        table.getSd().getCols().removeIf(fieldSchema -> fieldSchema.getName().equals(columnName));
        this.alterTable(databaseName, tableName, table);
    }

    private void alterTable(String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) {
        this.delegate.alterTable(databaseName, tableName, table);
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        return this.delegate.getPartition(databaseName, tableName, partitionValues).map(ThriftMetastoreUtil::fromMetastoreApiPartition);
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        return this.delegate.getPartitionNames(databaseName, tableName);
    }

    @Override
    public List<String> getPartitionNamesByFilter(String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        return this.delegate.getPartitionNamesByFilter(databaseName, tableName, partitionPredicates);
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), MetastoreUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = this.delegate.getPartitionsByNames(databaseName, tableName, partitionNames).stream().map(ThriftMetastoreUtil::fromMetastoreApiPartition).collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put(entry.getKey(), Optional.ofNullable(partition));
        }
        return resultBuilder.build();
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.delegate.addPartitions(databaseName, tableName, partitions);
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        this.delegate.alterPartition(databaseName, tableName, partition);
    }

    @Override
    public void createRole(String role, String grantor) {
        this.delegate.createRole(role, grantor);
    }

    @Override
    public void dropRole(String role) {
        this.delegate.dropRole(role);
    }

    @Override
    public Set<String> listRoles() {
        return this.delegate.listRoles();
    }

    @Override
    public void grantRoles(Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        this.delegate.grantRoles(roles, grantees, withAdminOption, grantor);
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        this.delegate.revokeRoles(roles, grantees, adminOptionFor, grantor);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(PrestoPrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.delegate.grantTablePrivileges(databaseName, tableName, grantee, privileges);
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.delegate.revokeTablePrivileges(databaseName, tableName, grantee, privileges);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, PrestoPrincipal principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, principal);
    }
}

