/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.ColumnConverter;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HiveColumnConverter;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveMetastoreUtil {
    private static final List<FieldSchema> TEST_SCHEMA = ImmutableList.of((Object)new FieldSchema("col1", "bigint", "comment1"), (Object)new FieldSchema("col2", "binary", null), (Object)new FieldSchema("col3", "string", null));
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR = new StorageDescriptor(TEST_SCHEMA, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 1)), (Map)ImmutableMap.of());
    private static final org.apache.hadoop.hive.metastore.api.Table TEST_TABLE = new org.apache.hadoop.hive.metastore.api.Table("table_name", "db_name", "owner_name", 0, 0, 0, TEST_STORAGE_DESCRIPTOR, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
    private static final org.apache.hadoop.hive.metastore.api.Partition TEST_PARTITION;
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS;
    private static final org.apache.hadoop.hive.metastore.api.Table TEST_TABLE_WITH_UNSUPPORTED_FIELDS;
    private static final org.apache.hadoop.hive.metastore.api.Partition TEST_PARTITION_WITH_UNSUPPORTED_FIELDS;
    private static final PartitionMutator TEST_PARTITION_VERSION_FETCHER;
    private static final ColumnConverter TEST_COLUMN_CONVERTER;

    @Test
    public void testTableRoundTrip() {
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE, TEST_SCHEMA, (ColumnConverter)TEST_COLUMN_CONVERTER);
        PrincipalPrivileges privileges = new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of());
        org.apache.hadoop.hive.metastore.api.Table metastoreApiTable = ThriftMetastoreUtil.toMetastoreApiTable((Table)table, (PrincipalPrivileges)privileges, (ColumnConverter)TEST_COLUMN_CONVERTER);
        Assert.assertEquals((Object)metastoreApiTable, (Object)TEST_TABLE);
    }

    @Test
    public void testPartitionRoundTrip() {
        Partition partition = ThriftMetastoreUtil.fromMetastoreApiPartition((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION, (PartitionMutator)TEST_PARTITION_VERSION_FETCHER, (ColumnConverter)TEST_COLUMN_CONVERTER);
        org.apache.hadoop.hive.metastore.api.Partition metastoreApiPartition = ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partition, (ColumnConverter)TEST_COLUMN_CONVERTER);
        Assert.assertEquals((Object)metastoreApiPartition, (Object)TEST_PARTITION);
    }

    @Test
    public void testHiveSchemaTable() {
        Properties expected = MetaStoreUtils.getTableMetadata((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS);
        expected.remove("column.name.delimiter");
        Properties actual = MetastoreUtil.getHiveSchema((Table)ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA, (ColumnConverter)TEST_COLUMN_CONVERTER));
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testHiveSchemaPartition() {
        Properties expected = MetaStoreUtils.getPartitionMetadata((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS, (org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS);
        expected.remove("column.name.delimiter");
        Properties actual = MetastoreUtil.getHiveSchema((Partition)ThriftMetastoreUtil.fromMetastoreApiPartition((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS, (PartitionMutator)TEST_PARTITION_VERSION_FETCHER, (ColumnConverter)TEST_COLUMN_CONVERTER), (Table)ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA, (ColumnConverter)TEST_COLUMN_CONVERTER));
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Writing to skewed table/partition is not supported")
    public void testTableRoundTripUnsupported() {
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA, (ColumnConverter)TEST_COLUMN_CONVERTER);
        ThriftMetastoreUtil.toMetastoreApiTable((Table)table, null, (ColumnConverter)TEST_COLUMN_CONVERTER);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Writing to skewed table/partition is not supported")
    public void testPartitionRoundTripUnsupported() {
        Partition partition = ThriftMetastoreUtil.fromMetastoreApiPartition((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS, (PartitionMutator)TEST_PARTITION_VERSION_FETCHER, (ColumnConverter)TEST_COLUMN_CONVERTER);
        ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partition, (ColumnConverter)TEST_COLUMN_CONVERTER);
    }

    @Test
    public void testReconstructPartitionSchema() {
        Column c1 = new Column("_c1", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column c2 = new Column("_c2", HiveType.HIVE_INT, Optional.empty(), Optional.empty());
        Column c3 = new Column("_c3", HiveType.HIVE_DOUBLE, Optional.empty(), Optional.empty());
        Column c4 = new Column("_c4", HiveType.HIVE_DATE, Optional.empty(), Optional.empty());
        Assert.assertEquals((Collection)MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of(), (int)0, (Map)ImmutableMap.of(), Optional.empty()), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of((Object)c1), (int)0, (Map)ImmutableMap.of(), Optional.empty()), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of((Object)c1), (int)1, (Map)ImmutableMap.of(), Optional.empty()), (Collection)ImmutableList.of((Object)c1));
        Assert.assertEquals((Collection)MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of((Object)c1, (Object)c2), (int)1, (Map)ImmutableMap.of(), Optional.empty()), (Collection)ImmutableList.of((Object)c1));
        Assert.assertEquals((Collection)MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of((Object)c1, (Object)c2), (int)3, (Map)ImmutableMap.of((Object)2, (Object)c3), Optional.empty()), (Collection)ImmutableList.of((Object)c1, (Object)c2, (Object)c3));
        Assert.assertEquals((Collection)MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of((Object)c1, (Object)c2, (Object)c3), (int)3, (Map)ImmutableMap.of((Object)1, (Object)c4), Optional.empty()), (Collection)ImmutableList.of((Object)c1, (Object)c4, (Object)c3));
        Assertions.assertThatThrownBy(() -> MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of(), (int)1, (Map)ImmutableMap.of(), Optional.empty())).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of((Object)c1), (int)2, (Map)ImmutableMap.of(), Optional.empty())).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> MetastoreUtil.reconstructPartitionSchema((List)ImmutableList.of((Object)c1), (int)2, (Map)ImmutableMap.of((Object)0, (Object)c2), Optional.empty())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testExtractPartitionValues() {
        String datePartition = "20201221";
        String countryPartition = "united_states";
        Assert.assertEquals((Collection)MetastoreUtil.extractPartitionValues((String)"datePartition=20201221/countryPartition=united_states", Optional.of(ImmutableList.of((Object)"datePartition", (Object)"countryPartition"))), (Collection)ImmutableList.of((Object)datePartition, (Object)countryPartition));
        Assert.assertEquals((Collection)MetastoreUtil.extractPartitionValues((String)"countryPartition=united_states/datePartition=20201221", Optional.of(ImmutableList.of((Object)"datePartition", (Object)"countryPartition"))), (Collection)ImmutableList.of((Object)datePartition, (Object)countryPartition));
        Assert.assertEquals((Collection)MetastoreUtil.extractPartitionValues((String)"datePartition=20201221/countryPartition=united_states"), (Collection)ImmutableList.of((Object)datePartition, (Object)countryPartition));
        Assert.assertEquals((Collection)MetastoreUtil.extractPartitionValues((String)"countryPartition=united_states/datePartition=20201221"), (Collection)ImmutableList.of((Object)countryPartition, (Object)datePartition));
    }

    static {
        TEST_TABLE.setPrivileges(new PrincipalPrivilegeSet((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        TEST_PARTITION = new org.apache.hadoop.hive.metastore.api.Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 0, 0, TEST_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS = new StorageDescriptor(TEST_SCHEMA, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 0), (Object)new Order("col3", 1)), (Map)ImmutableMap.of((Object)"sk1", (Object)"sv1"));
        TEST_TABLE_WITH_UNSUPPORTED_FIELDS = new org.apache.hadoop.hive.metastore.api.Table("table_name", "db_name", "owner_name", 1234567890, 1234567891, 34, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
        TEST_PARTITION_WITH_UNSUPPORTED_FIELDS = new org.apache.hadoop.hive.metastore.api.Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 1234567892, 1234567893, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_PARTITION_VERSION_FETCHER = new HivePartitionMutator();
        TEST_COLUMN_CONVERTER = new HiveColumnConverter();
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS.setSkewedInfo(new SkewedInfo((List)ImmutableList.of((Object)"col1"), (List)ImmutableList.of((Object)ImmutableList.of((Object)"val1")), (Map)ImmutableMap.of((Object)ImmutableList.of((Object)"val1"), (Object)"loc1")));
    }
}

