/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestMetastoreClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MetastoreClientConfig)ConfigAssertions.recordDefaults(MetastoreClientConfig.class)).setMetastoreSocksProxy(null).setMetastoreTimeout(new Duration(10.0, TimeUnit.SECONDS)).setVerifyChecksum(true).setRequireHadoopNative(true).setMetastoreCacheTtl(new Duration(0.0, TimeUnit.SECONDS)).setMetastoreRefreshInterval(new Duration(0.0, TimeUnit.SECONDS)).setMetastoreCacheMaximumSize(10000L).setPerTransactionMetastoreCacheMaximumSize(1000L).setMaxMetastoreRefreshThreads(100).setRecordingPath(null).setRecordingDuration(new Duration(0.0, TimeUnit.MINUTES)).setReplay(false).setPartitionVersioningEnabled(false).setMetastoreCacheScope(CachingHiveMetastore.MetastoreCacheScope.ALL).setMetastoreImpersonationEnabled(false).setPartitionCacheValidationPercentage(0.0).setPartitionCacheColumnCountLimit(500).setHiveMetastoreAuthenticationType(MetastoreClientConfig.HiveMetastoreAuthenticationType.NONE).setDeleteFilesOnTableDrop(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.metastore.thrift.client.socks-proxy", (Object)"localhost:1080").put((Object)"hive.metastore-timeout", (Object)"20s").put((Object)"hive.dfs.verify-checksum", (Object)"false").put((Object)"hive.dfs.require-hadoop-native", (Object)"false").put((Object)"hive.metastore-cache-ttl", (Object)"2h").put((Object)"hive.metastore-refresh-interval", (Object)"30m").put((Object)"hive.metastore-cache-maximum-size", (Object)"5000").put((Object)"hive.per-transaction-metastore-cache-maximum-size", (Object)"500").put((Object)"hive.metastore-refresh-max-threads", (Object)"2500").put((Object)"hive.metastore-recording-path", (Object)"/foo/bar").put((Object)"hive.metastore-recoding-duration", (Object)"42s").put((Object)"hive.replay-metastore-recording", (Object)"true").put((Object)"hive.partition-versioning-enabled", (Object)"true").put((Object)"hive.metastore-cache-scope", (Object)"PARTITION").put((Object)"hive.metastore-impersonation-enabled", (Object)"true").put((Object)"hive.partition-cache-validation-percentage", (Object)"60.0").put((Object)"hive.partition-cache-column-count-limit", (Object)"50").put((Object)"hive.metastore.authentication.type", (Object)"KERBEROS").put((Object)"hive.metastore.thrift.delete-files-on-table-drop", (Object)"true").build();
        MetastoreClientConfig expected = new MetastoreClientConfig().setMetastoreSocksProxy(HostAndPort.fromParts((String)"localhost", (int)1080)).setMetastoreTimeout(new Duration(20.0, TimeUnit.SECONDS)).setVerifyChecksum(false).setRequireHadoopNative(false).setMetastoreCacheTtl(new Duration(2.0, TimeUnit.HOURS)).setMetastoreRefreshInterval(new Duration(30.0, TimeUnit.MINUTES)).setMetastoreCacheMaximumSize(5000L).setPerTransactionMetastoreCacheMaximumSize(500L).setMaxMetastoreRefreshThreads(2500).setRecordingPath("/foo/bar").setRecordingDuration(new Duration(42.0, TimeUnit.SECONDS)).setReplay(true).setPartitionVersioningEnabled(true).setMetastoreCacheScope(CachingHiveMetastore.MetastoreCacheScope.PARTITION).setMetastoreImpersonationEnabled(true).setPartitionCacheValidationPercentage(60.0).setPartitionCacheColumnCountLimit(50).setHiveMetastoreAuthenticationType(MetastoreClientConfig.HiveMetastoreAuthenticationType.KERBEROS).setDeleteFilesOnTableDrop(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

