/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.IntegerStatistics;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.RecordingHiveMetastore;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.UnimplementedHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.MockHiveMetastoreClient;
import com.facebook.presto.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRecordingHiveMetastore {
    private static final Database DATABASE = new Database("database", Optional.of("location"), "owner", PrincipalType.USER, Optional.of("comment"), (Map)ImmutableMap.of((Object)"param", (Object)"value"));
    private static final Column TABLE_COLUMN = new Column("column", HiveType.HIVE_INT, Optional.of("comment"), Optional.empty());
    private static final Column TABLE_COLUMN_PK = new Column("column_pk", HiveType.HIVE_INT, Optional.of("Primary Key"), Optional.empty());
    private static final Column TABLE_COLUMN_UNIQUE = new Column("column_unique", HiveType.HIVE_INT, Optional.of("Unique Key"), Optional.empty());
    private static final Storage TABLE_STORAGE = new Storage(StorageFormat.create((String)"serde", (String)"input", (String)"output"), "location", Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"column"), 10, (List)ImmutableList.of((Object)new SortingColumn("column", SortingColumn.Order.ASCENDING)), BucketFunctionType.HIVE_COMPATIBLE, Optional.empty())), true, (Map)ImmutableMap.of((Object)"param", (Object)"value2"), (Map)ImmutableMap.of());
    private static final Table TABLE = new Table("database", "table", "owner", PrestoTableType.OTHER, TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN, (Object)TABLE_COLUMN_PK, (Object)TABLE_COLUMN_UNIQUE), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value3"), Optional.of("original_text"), Optional.of("expanded_text"));
    private static final Partition PARTITION = new Partition("database", "table", (List)ImmutableList.of((Object)"value"), TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value4"), Optional.empty(), false, true, 0, 0L);
    private static final PartitionStatistics PARTITION_STATISTICS = new PartitionStatistics(new HiveBasicStatistics(10L, 11L, 10000L, 10001L), (Map)ImmutableMap.of((Object)"column", (Object)new HiveColumnStatistics(Optional.of(new IntegerStatistics(OptionalLong.of(-100L), OptionalLong.of(102L))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.of(1234L), OptionalLong.of(1235L), OptionalLong.of(1L), OptionalLong.of(8L))));
    private static final HivePrivilegeInfo PRIVILEGE_INFO = new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, new PrestoPrincipal(PrincipalType.USER, "grantor"), new PrestoPrincipal(PrincipalType.USER, "grantee"));
    private static final RoleGrant ROLE_GRANT = new RoleGrant(new PrestoPrincipal(PrincipalType.USER, "grantee"), "role", true);
    private static final PrimaryKeyConstraint<String> TEST_PRIMARY_KEY = new PrimaryKeyConstraint("", (Set)ImmutableSet.of((Object)"column_pk"), true, true);
    private static final UniqueConstraint<String> TEST_UNIQUE_CONSTRAINT = new UniqueConstraint("", (Set)ImmutableSet.of((Object)"column_unique"), true, true);

    @Test
    public void testRecordingHiveMetastore() throws IOException {
        MetastoreClientConfig recordingHiveClientConfig = new MetastoreClientConfig().setRecordingPath(File.createTempFile("recording_test", "json").getAbsolutePath()).setRecordingDuration(new Duration(10.0, TimeUnit.MINUTES));
        RecordingHiveMetastore recordingHiveMetastore = new RecordingHiveMetastore((ExtendedHiveMetastore)new TestingHiveMetastore(), recordingHiveClientConfig);
        this.validateMetadata((ExtendedHiveMetastore)recordingHiveMetastore);
        recordingHiveMetastore.dropDatabase(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "other_database");
        recordingHiveMetastore.writeRecording();
        MetastoreClientConfig replayingHiveClientConfig = recordingHiveClientConfig.setReplay(true);
        recordingHiveMetastore = new RecordingHiveMetastore((ExtendedHiveMetastore)new UnimplementedHiveMetastore(), replayingHiveClientConfig);
        recordingHiveMetastore.loadRecording();
        this.validateMetadata((ExtendedHiveMetastore)recordingHiveMetastore);
    }

    private void validateMetadata(ExtendedHiveMetastore hiveMetastore) {
        Assert.assertEquals((Object)hiveMetastore.getDatabase(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database"), Optional.of(DATABASE));
        Assert.assertEquals((Collection)hiveMetastore.getAllDatabases(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)ImmutableList.of((Object)"database"));
        Assert.assertEquals((Object)hiveMetastore.getTable(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table"), Optional.of(TABLE));
        Assert.assertEquals((Set)hiveMetastore.getSupportedColumnStatistics(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, (Type)VarcharType.createVarcharType((int)123)), (Set)ImmutableSet.of((Object)ColumnStatisticType.MIN_VALUE, (Object)ColumnStatisticType.MAX_VALUE));
        Assert.assertEquals((Object)hiveMetastore.getTableStatistics(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table"), (Object)PARTITION_STATISTICS);
        Assert.assertEquals((Map)hiveMetastore.getPartitionStatistics(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table", (Set)ImmutableSet.of((Object)"value")), (Map)ImmutableMap.of((Object)"value", (Object)PARTITION_STATISTICS));
        Assert.assertEquals((Object)hiveMetastore.getAllTables(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database"), Optional.of(ImmutableList.of((Object)"table")));
        Assert.assertEquals((Object)hiveMetastore.getAllViews(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database"), Optional.empty());
        Assert.assertEquals((Object)hiveMetastore.getPartition(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table", (List)ImmutableList.of((Object)"value")), Optional.of(PARTITION));
        Assert.assertEquals((Object)hiveMetastore.getPartitionNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table"), Optional.of(ImmutableList.of((Object)"value")));
        HashMap<Column, Domain> map = new HashMap<Column, Domain>();
        Column column = new Column("column", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        map.put(column, Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")));
        Assert.assertEquals((Collection)hiveMetastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table", map), (Collection)ImmutableList.of((Object)"value"));
        Assert.assertEquals((Map)hiveMetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table", (List)ImmutableList.of((Object)"value")), (Map)ImmutableMap.of((Object)"value", Optional.of(PARTITION)));
        Assert.assertEquals((Set)hiveMetastore.listTablePrivileges(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table", new PrestoPrincipal(PrincipalType.USER, "user")), (Set)ImmutableSet.of((Object)PRIVILEGE_INFO));
        Assert.assertEquals((Set)hiveMetastore.listRoles(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Set)ImmutableSet.of((Object)"role"));
        Assert.assertEquals((Set)hiveMetastore.listRoleGrants(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, new PrestoPrincipal(PrincipalType.USER, "user")), (Set)ImmutableSet.of((Object)ROLE_GRANT));
        Assert.assertEquals((Collection)hiveMetastore.getTableConstraints(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "database", "table"), (Collection)ImmutableList.of(TEST_PRIMARY_KEY, TEST_UNIQUE_CONSTRAINT));
    }

    private static class TestingHiveMetastore
    extends UnimplementedHiveMetastore {
        private TestingHiveMetastore() {
        }

        @Override
        public Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
            if (databaseName.equals("database")) {
                return Optional.of(DATABASE);
            }
            return Optional.empty();
        }

        @Override
        public List<String> getAllDatabases(MetastoreContext metastoreContext) {
            return ImmutableList.of((Object)"database");
        }

        @Override
        public Optional<Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
            if (databaseName.equals("database") && tableName.equals("table")) {
                return Optional.of(TABLE);
            }
            return Optional.empty();
        }

        @Override
        public Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext metastoreContext, Type type) {
            if (type.equals(VarcharType.createVarcharType((int)123))) {
                return ImmutableSet.of((Object)ColumnStatisticType.MIN_VALUE, (Object)ColumnStatisticType.MAX_VALUE);
            }
            return ImmutableSet.of();
        }

        @Override
        public PartitionStatistics getTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName) {
            if (databaseName.equals("database") && tableName.equals("table")) {
                return PARTITION_STATISTICS;
            }
            return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        }

        @Override
        public Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames) {
            if (databaseName.equals("database") && tableName.equals("table") && partitionNames.contains("value")) {
                return ImmutableMap.of((Object)"value", (Object)PARTITION_STATISTICS);
            }
            return ImmutableMap.of();
        }

        @Override
        public Optional<List<String>> getAllTables(MetastoreContext metastoreContext, String databaseName) {
            if (databaseName.equals("database")) {
                return Optional.of(ImmutableList.of((Object)"table"));
            }
            return Optional.empty();
        }

        @Override
        public Optional<List<String>> getAllViews(MetastoreContext metastoreContext, String databaseName) {
            return Optional.empty();
        }

        @Override
        public void dropDatabase(MetastoreContext metastoreContext, String databaseName) {
        }

        @Override
        public Optional<Partition> getPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
            if (databaseName.equals("database") && tableName.equals("table") && partitionValues.equals(ImmutableList.of((Object)"value"))) {
                return Optional.of(PARTITION);
            }
            return Optional.empty();
        }

        @Override
        public Optional<List<String>> getPartitionNames(MetastoreContext metastoreContext, String databaseName, String tableName) {
            if (databaseName.equals("database") && tableName.equals("table")) {
                return Optional.of(ImmutableList.of((Object)"value"));
            }
            return Optional.empty();
        }

        @Override
        public List<String> getPartitionNamesByFilter(MetastoreContext metastoreContext, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
            List parts = MetastoreUtil.convertPredicateToParts(partitionPredicates);
            if (databaseName.equals("database") && tableName.equals("table") && parts.equals(ImmutableList.of((Object)"value"))) {
                return ImmutableList.of((Object)"value");
            }
            return ImmutableList.of();
        }

        @Override
        public Map<String, Optional<Partition>> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionNames) {
            if (databaseName.equals("database") && tableName.equals("table") && partitionNames.contains("value")) {
                return ImmutableMap.of((Object)"value", Optional.of(PARTITION));
            }
            return ImmutableMap.of();
        }

        @Override
        public Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext metastoreContext, String database, String table, PrestoPrincipal prestoPrincipal) {
            if (database.equals("database") && table.equals("table") && prestoPrincipal.getType() == PrincipalType.USER && prestoPrincipal.getName().equals("user")) {
                return ImmutableSet.of((Object)PRIVILEGE_INFO);
            }
            return ImmutableSet.of();
        }

        @Override
        public Set<String> listRoles(MetastoreContext metastoreContext) {
            return ImmutableSet.of((Object)"role");
        }

        @Override
        public Set<RoleGrant> listRoleGrants(MetastoreContext metastoreContext, PrestoPrincipal principal) {
            return ImmutableSet.of((Object)ROLE_GRANT);
        }

        public List<TableConstraint<String>> getTableConstraints(MetastoreContext metastoreContext, String database, String table) {
            if (database.equals("database") && table.equals("table")) {
                ArrayList<TableConstraint<String>> constraints = new ArrayList<TableConstraint<String>>();
                constraints.add((TableConstraint<String>)TEST_PRIMARY_KEY);
                constraints.add((TableConstraint<String>)TEST_UNIQUE_CONSTRAINT);
                return constraints;
            }
            return ImmutableList.of();
        }
    }
}

