/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.file.PartitionMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartitionMetadata {
    private static final JsonCodec<PartitionMetadata> JSON_CODEC = JsonCodec.jsonCodec(PartitionMetadata.class);
    private static final String BASE_DIR = "src/test/resources/PR-17368";
    private static final String FILE_NAME_FORMAT = "partition-0.271-%s.json";
    private static final String STORAGE_FORMAT_NOT_EQUALS = "storage format not equals";
    private static final StorageFormat ORC = StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC);
    private static final StorageFormat PARQUET = StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET);
    private static final StorageFormat CUSTOM = StorageFormat.create((String)"serde", (String)"inputFormat", (String)"outputFormat");

    @Test
    public void testAssertPartitionMetadataEquals() {
        TestPartitionMetadata.assertPartitionMetadataEquals(TestPartitionMetadata.createPartitionMetadata(null), TestPartitionMetadata.createPartitionMetadata(null));
        TestPartitionMetadata.assertPartitionMetadataEquals(TestPartitionMetadata.createPartitionMetadata(ORC), TestPartitionMetadata.createPartitionMetadata(ORC));
        TestPartitionMetadata.assertPartitionMetadataEquals(TestPartitionMetadata.createPartitionMetadata(PARQUET), TestPartitionMetadata.createPartitionMetadata(PARQUET));
        Assertions.assertThatThrownBy(() -> TestPartitionMetadata.assertPartitionMetadataEquals(TestPartitionMetadata.createPartitionMetadata(null), TestPartitionMetadata.createPartitionMetadata(ORC))).hasMessageContaining(STORAGE_FORMAT_NOT_EQUALS);
        Assertions.assertThatThrownBy(() -> TestPartitionMetadata.assertPartitionMetadataEquals(TestPartitionMetadata.createPartitionMetadata(PARQUET), TestPartitionMetadata.createPartitionMetadata(ORC))).hasMessageContaining(STORAGE_FORMAT_NOT_EQUALS);
    }

    @Test
    public void testJsonRoundTrip() {
        TestPartitionMetadata.assertJsonRoundTrip(TestPartitionMetadata.createPartitionMetadata(null));
        TestPartitionMetadata.assertJsonRoundTrip(TestPartitionMetadata.createPartitionMetadata(ORC));
        TestPartitionMetadata.assertJsonRoundTrip(TestPartitionMetadata.createPartitionMetadata(PARQUET));
        TestPartitionMetadata.assertJsonRoundTrip(TestPartitionMetadata.createPartitionMetadata(CUSTOM));
    }

    @Test
    public void testDecodeFromLegacyFile() throws IOException {
        TestPartitionMetadata.assertPartitionMetadataEquals(TestPartitionMetadata.load("null"), TestPartitionMetadata.createPartitionMetadata(null));
        TestPartitionMetadata.assertPartitionMetadataEquals(TestPartitionMetadata.load("orc"), TestPartitionMetadata.createPartitionMetadata(ORC));
        TestPartitionMetadata.assertPartitionMetadataEquals(TestPartitionMetadata.load("parquet"), TestPartitionMetadata.createPartitionMetadata(PARQUET));
    }

    private static PartitionMetadata load(String tag) throws IOException {
        return (PartitionMetadata)JSON_CODEC.fromBytes(Files.readAllBytes(Paths.get(BASE_DIR, String.format(FILE_NAME_FORMAT, tag))));
    }

    private static void assertJsonRoundTrip(PartitionMetadata partition) {
        PartitionMetadata decoded = (PartitionMetadata)JSON_CODEC.fromJson(JSON_CODEC.toJson((Object)partition));
        TestPartitionMetadata.assertPartitionMetadataEquals(decoded, partition);
    }

    private static void assertPartitionMetadataEquals(PartitionMetadata actual, PartitionMetadata expected) {
        Assert.assertEquals((Collection)actual.getColumns(), (Collection)expected.getColumns());
        Assert.assertEquals((Map)actual.getParameters(), (Map)expected.getParameters());
        Assert.assertEquals((Object)actual.getStorageFormat(), (Object)expected.getStorageFormat(), (String)STORAGE_FORMAT_NOT_EQUALS);
        Assert.assertEquals((Object)actual.getBucketProperty(), (Object)expected.getBucketProperty());
        Assert.assertEquals((Map)actual.getStorageParameters(), (Map)expected.getStorageParameters());
        Assert.assertEquals((Map)actual.getSerdeParameters(), (Map)expected.getSerdeParameters());
        Assert.assertEquals((Object)actual.getExternalLocation(), (Object)expected.getExternalLocation());
        Assert.assertEquals((Map)actual.getColumnStatistics(), (Map)expected.getColumnStatistics());
        Assert.assertEquals((boolean)actual.isEligibleToIgnore(), (boolean)expected.isEligibleToIgnore());
        Assert.assertEquals((boolean)actual.isSealedPartition(), (boolean)expected.isSealedPartition());
        Assert.assertEquals((Object)actual.getPartitionStorageFormat(), (Object)expected.getPartitionStorageFormat(), (String)STORAGE_FORMAT_NOT_EQUALS);
    }

    private static PartitionMetadata createPartitionMetadata(StorageFormat format) {
        return new PartitionMetadata((List)ImmutableList.of((Object)TestPartitionMetadata.column("col1"), (Object)TestPartitionMetadata.column("col2")), (Map)ImmutableMap.of((Object)"param1", (Object)"value1", (Object)"param2", (Object)"value2"), format, Optional.empty(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), (Map)ImmutableMap.of(), false, false);
    }

    private static Column column(String name) {
        return new Column(name, HiveType.HIVE_STRING, Optional.of(name), Optional.empty());
    }
}

