/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.file.StorageFormatCompatDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStorageFormatCompatDeserializer {
    @Test
    public void testStorageFormatCompatDeserializer() {
        JsonCodec codecV1 = JsonCodec.jsonCodec(ProtocolV1.class);
        JsonCodec codecV2 = JsonCodec.jsonCodec(ProtocolV2.class);
        ProtocolV1 v1 = new ProtocolV1(1234, HiveStorageFormat.JSON);
        ProtocolV2 v2 = new ProtocolV2(1234, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.JSON));
        ProtocolV2 v2FromV1 = (ProtocolV2)codecV2.fromJson(codecV1.toJson((Object)v1));
        Assert.assertEquals((Object)v2FromV1, (Object)v2);
        ProtocolV2 v2FromV2 = (ProtocolV2)codecV2.fromJson(codecV2.toJson((Object)v2));
        Assert.assertEquals((Object)v2FromV2, (Object)v2);
    }

    public static class ProtocolV2 {
        private final int id;
        private final StorageFormat format;

        @JsonCreator
        public ProtocolV2(@JsonProperty(value="id") int id, @JsonDeserialize(using=StorageFormatCompatDeserializer.class) @JsonProperty(value="format") StorageFormat format) {
            this.id = id;
            this.format = Objects.requireNonNull(format, "format is null");
        }

        @JsonProperty
        public int getId() {
            return this.id;
        }

        @JsonProperty
        public StorageFormat getFormat() {
            return this.format;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProtocolV2 that = (ProtocolV2)o;
            return this.id == that.id && this.format.equals((Object)that.format);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.format);
        }
    }

    public static class ProtocolV1 {
        private final int id;
        private final HiveStorageFormat format;

        @JsonCreator
        public ProtocolV1(@JsonProperty(value="id") int id, @JsonProperty(value="format") HiveStorageFormat format) {
            this.id = id;
            this.format = Objects.requireNonNull(format, "format is null");
        }

        @JsonProperty
        public int getId() {
            return this.id;
        }

        @JsonProperty
        public HiveStorageFormat getFormat() {
            return this.format;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProtocolV1 that = (ProtocolV1)o;
            return this.id == that.id && this.format == that.format;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.format);
        }
    }
}

