/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.file.TableMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTableMetadata {
    private static final JsonCodec<TableMetadata> JSON_CODEC = JsonCodec.jsonCodec(TableMetadata.class);
    private static final String BASE_DIR = "src/test/resources/PR-17368";
    private static final String FILE_NAME_FORMAT = "table-0.271-%s.json";
    private static final String STORAGE_FORMAT_NOT_EQUALS = "storage format not equals";
    private static final StorageFormat ORC = StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC);
    private static final StorageFormat PARQUET = StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET);
    private static final StorageFormat CUSTOM = StorageFormat.create((String)"serde", (String)"inputFormat", (String)"outputFormat");

    @Test
    public void testAssertTableMetadataEquals() {
        TestTableMetadata.assertTableMetadataEquals(TestTableMetadata.createTableMetadata(null), TestTableMetadata.createTableMetadata(null));
        TestTableMetadata.assertTableMetadataEquals(TestTableMetadata.createTableMetadata(ORC), TestTableMetadata.createTableMetadata(ORC));
        TestTableMetadata.assertTableMetadataEquals(TestTableMetadata.createTableMetadata(PARQUET), TestTableMetadata.createTableMetadata(PARQUET));
        Assertions.assertThatThrownBy(() -> TestTableMetadata.assertTableMetadataEquals(TestTableMetadata.createTableMetadata(null), TestTableMetadata.createTableMetadata(ORC))).hasMessageContaining(STORAGE_FORMAT_NOT_EQUALS);
        Assertions.assertThatThrownBy(() -> TestTableMetadata.assertTableMetadataEquals(TestTableMetadata.createTableMetadata(PARQUET), TestTableMetadata.createTableMetadata(ORC))).hasMessageContaining(STORAGE_FORMAT_NOT_EQUALS);
    }

    @Test
    public void testJsonRoundTrip() {
        TestTableMetadata.assertJsonRoundTrip(TestTableMetadata.createTableMetadata(null));
        TestTableMetadata.assertJsonRoundTrip(TestTableMetadata.createTableMetadata(ORC));
        TestTableMetadata.assertJsonRoundTrip(TestTableMetadata.createTableMetadata(PARQUET));
        TestTableMetadata.assertJsonRoundTrip(TestTableMetadata.createTableMetadata(CUSTOM));
    }

    @Test
    public void testDecodeFromLegacyFile() throws IOException {
        TestTableMetadata.assertTableMetadataEquals(TestTableMetadata.load("null"), TestTableMetadata.createTableMetadata(null));
        TestTableMetadata.assertTableMetadataEquals(TestTableMetadata.load("orc"), TestTableMetadata.createTableMetadata(ORC));
        TestTableMetadata.assertTableMetadataEquals(TestTableMetadata.load("parquet"), TestTableMetadata.createTableMetadata(PARQUET));
    }

    private static TableMetadata load(String tag) throws IOException {
        return (TableMetadata)JSON_CODEC.fromBytes(Files.readAllBytes(Paths.get(BASE_DIR, String.format(FILE_NAME_FORMAT, tag))));
    }

    private static void assertJsonRoundTrip(TableMetadata table) {
        TableMetadata decoded = (TableMetadata)JSON_CODEC.fromJson(JSON_CODEC.toJson((Object)table));
        TestTableMetadata.assertTableMetadataEquals(decoded, table);
    }

    private static void assertTableMetadataEquals(TableMetadata actual, TableMetadata expected) {
        Assert.assertEquals((String)actual.getOwner(), (String)expected.getOwner());
        Assert.assertEquals((Object)actual.getTableType(), (Object)expected.getTableType());
        Assert.assertEquals((Collection)actual.getDataColumns(), (Collection)expected.getDataColumns());
        Assert.assertEquals((Collection)actual.getPartitionColumns(), (Collection)expected.getPartitionColumns());
        Assert.assertEquals((Map)actual.getParameters(), (Map)expected.getParameters());
        Assert.assertEquals((Object)actual.getStorageFormat(), (Object)expected.getStorageFormat(), (String)STORAGE_FORMAT_NOT_EQUALS);
        Assert.assertEquals((Object)actual.getBucketProperty(), (Object)expected.getBucketProperty());
        Assert.assertEquals((Map)actual.getStorageParameters(), (Map)expected.getStorageParameters());
        Assert.assertEquals((Map)actual.getSerdeParameters(), (Map)expected.getSerdeParameters());
        Assert.assertEquals((Object)actual.getExternalLocation(), (Object)expected.getExternalLocation());
        Assert.assertEquals((Object)actual.getViewOriginalText(), (Object)expected.getViewOriginalText());
        Assert.assertEquals((Object)actual.getViewExpandedText(), (Object)expected.getViewExpandedText());
        Assert.assertEquals((Map)actual.getColumnStatistics(), (Map)expected.getColumnStatistics());
        Assert.assertEquals((Object)actual.getTableStorageFormat(), (Object)expected.getTableStorageFormat(), (String)STORAGE_FORMAT_NOT_EQUALS);
    }

    private static TableMetadata createTableMetadata(StorageFormat format) {
        return new TableMetadata("owner0", PrestoTableType.EXTERNAL_TABLE, (List)ImmutableList.of((Object)TestTableMetadata.column("col1"), (Object)TestTableMetadata.column("col2")), (List)ImmutableList.of((Object)TestTableMetadata.column("part1")), (Map)ImmutableMap.of((Object)"param1", (Object)"value1", (Object)"param2", (Object)"value2"), format, Optional.empty(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.of("/tmp/location"), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
    }

    private static Column column(String name) {
        return new Column(name, HiveType.HIVE_STRING, Optional.of(name), Optional.empty());
    }
}

