/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.hive.metastore.glue.GlueHiveMetastoreConfig;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestGlueHiveMetastoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((GlueHiveMetastoreConfig)ConfigAssertions.recordDefaults(GlueHiveMetastoreConfig.class)).setGlueRegion(null).setGlueEndpointUrl(null).setPinGlueClientToCurrentRegion(false).setMaxGlueConnections(5).setMaxGlueErrorRetries(10).setDefaultWarehouseDir(null).setCatalogId(null).setPartitionSegments(5).setGetPartitionThreads(20).setIamRole(null).setAwsAccessKey(null).setAwsSecretKey(null));
    }

    @Test
    public void testExplicitPropertyMapping() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.metastore.glue.region", (Object)"us-east-1").put((Object)"hive.metastore.glue.endpoint-url", (Object)"http://foo.bar").put((Object)"hive.metastore.glue.pin-client-to-current-region", (Object)"true").put((Object)"hive.metastore.glue.max-connections", (Object)"10").put((Object)"hive.metastore.glue.max-error-retries", (Object)"20").put((Object)"hive.metastore.glue.default-warehouse-dir", (Object)"/location").put((Object)"hive.metastore.glue.catalogid", (Object)"0123456789").put((Object)"hive.metastore.glue.partitions-segments", (Object)"10").put((Object)"hive.metastore.glue.get-partition-threads", (Object)"42").put((Object)"hive.metastore.glue.iam-role", (Object)"role").put((Object)"hive.metastore.glue.aws-access-key", (Object)"ABC").put((Object)"hive.metastore.glue.aws-secret-key", (Object)"DEF").build();
        GlueHiveMetastoreConfig expected = new GlueHiveMetastoreConfig().setGlueRegion("us-east-1").setGlueEndpointUrl("http://foo.bar").setPinGlueClientToCurrentRegion(true).setMaxGlueConnections(10).setMaxGlueErrorRetries(20).setDefaultWarehouseDir("/location").setCatalogId("0123456789").setPartitionSegments(10).setGetPartitionThreads(42).setIamRole("role").setAwsAccessKey("ABC").setAwsSecretKey("DEF");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

