/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.hive.metastore.thrift.StaticMetastoreConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStaticMetastoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((StaticMetastoreConfig)ConfigAssertions.recordDefaults(StaticMetastoreConfig.class)).setMetastoreUris(null).setMetastoreUsername(null).setMetastoreLoadBalancingEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappingsSingleMetastore() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.metastore.uri", (Object)"thrift://localhost:9083").put((Object)"hive.metastore.username", (Object)"presto").put((Object)"hive.metastore.load-balancing-enabled", (Object)"true").build();
        StaticMetastoreConfig expected = new StaticMetastoreConfig().setMetastoreUris("thrift://localhost:9083").setMetastoreUsername("presto").setMetastoreLoadBalancingEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        Assert.assertEquals((Collection)expected.getMetastoreUris(), (Collection)ImmutableList.of((Object)URI.create("thrift://localhost:9083")));
        Assert.assertEquals((String)expected.getMetastoreUsername(), (String)"presto");
    }

    @Test
    public void testExplicitPropertyMappingsMultipleMetastores() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.metastore.uri", (Object)"thrift://localhost:9083,thrift://192.0.2.3:8932").put((Object)"hive.metastore.username", (Object)"presto").put((Object)"hive.metastore.load-balancing-enabled", (Object)"true").build();
        StaticMetastoreConfig expected = new StaticMetastoreConfig().setMetastoreUris("thrift://localhost:9083,thrift://192.0.2.3:8932").setMetastoreUsername("presto").setMetastoreLoadBalancingEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        Assert.assertEquals((Collection)expected.getMetastoreUris(), (Collection)ImmutableList.of((Object)URI.create("thrift://localhost:9083"), (Object)URI.create("thrift://192.0.2.3:8932")));
        Assert.assertEquals((String)expected.getMetastoreUsername(), (String)"presto");
    }
}

