/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.metastore.BooleanStatistics;
import com.facebook.presto.hive.metastore.DateStatistics;
import com.facebook.presto.hive.metastore.DecimalStatistics;
import com.facebook.presto.hive.metastore.DoubleStatistics;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.IntegerStatistics;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftHiveMetastoreUtil {
    @Test
    public void testLongStatsToColumnStatistics() {
        LongColumnStatsData longColumnStatsData = new LongColumnStatsData();
        longColumnStatsData.setLowValue(0L);
        longColumnStatsData.setHighValue(100L);
        longColumnStatsData.setNumNulls(1L);
        longColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "bigint", ColumnStatisticsData.longStats((LongColumnStatsData)longColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(1000L));
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.of(new IntegerStatistics(OptionalLong.of(0L), OptionalLong.of(100L))));
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(1L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(19L));
    }

    @Test
    public void testEmptyLongStatsToColumnStatistics() {
        LongColumnStatsData emptyLongColumnStatsData = new LongColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "bigint", ColumnStatisticsData.longStats((LongColumnStatsData)emptyLongColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.of(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty())));
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testDoubleStatsToColumnStatistics() {
        DoubleColumnStatsData doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setLowValue(0.0);
        doubleColumnStatsData.setHighValue(100.0);
        doubleColumnStatsData.setNumNulls(1L);
        doubleColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(1000L));
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.of(new DoubleStatistics(OptionalDouble.of(0.0), OptionalDouble.of(100.0))));
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(1L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(19L));
    }

    @Test
    public void testEmptyDoubleStatsToColumnStatistics() {
        DoubleColumnStatsData emptyDoubleColumnStatsData = new DoubleColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)emptyDoubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.of(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty())));
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testDecimalStatsToColumnStatistics() {
        DecimalColumnStatsData decimalColumnStatsData = new DecimalColumnStatsData();
        BigDecimal low = new BigDecimal("0");
        decimalColumnStatsData.setLowValue(ThriftMetastoreUtil.toMetastoreDecimal((BigDecimal)low));
        BigDecimal high = new BigDecimal("100");
        decimalColumnStatsData.setHighValue(ThriftMetastoreUtil.toMetastoreDecimal((BigDecimal)high));
        decimalColumnStatsData.setNumNulls(1L);
        decimalColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "decimal", ColumnStatisticsData.decimalStats((DecimalColumnStatsData)decimalColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(1000L));
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.of(new DecimalStatistics(Optional.of(low), Optional.of(high))));
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(1L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(19L));
    }

    @Test
    public void testEmptyDecimalStatsToColumnStatistics() {
        DecimalColumnStatsData emptyDecimalColumnStatsData = new DecimalColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "decimal", ColumnStatisticsData.decimalStats((DecimalColumnStatsData)emptyDecimalColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.of(new DecimalStatistics(Optional.empty(), Optional.empty())));
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testBooleanStatsToColumnStatistics() {
        BooleanColumnStatsData booleanColumnStatsData = new BooleanColumnStatsData();
        booleanColumnStatsData.setNumTrues(100L);
        booleanColumnStatsData.setNumFalses(10L);
        booleanColumnStatsData.setNumNulls(0L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)booleanColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.of(new BooleanStatistics(OptionalLong.of(100L), OptionalLong.of(10L))));
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(0L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testEmptyBooleanStatsToColumnStatistics() {
        BooleanColumnStatsData emptyBooleanColumnStatsData = new BooleanColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)emptyBooleanColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.of(new BooleanStatistics(OptionalLong.empty(), OptionalLong.empty())));
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testDateStatsToColumnStatistics() {
        DateColumnStatsData dateColumnStatsData = new DateColumnStatsData();
        dateColumnStatsData.setLowValue(new Date(1000L));
        dateColumnStatsData.setHighValue(new Date(2000L));
        dateColumnStatsData.setNumNulls(1L);
        dateColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "date", ColumnStatisticsData.dateStats((DateColumnStatsData)dateColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(1000L));
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.of(new DateStatistics(Optional.of(LocalDate.ofEpochDay(1000L)), Optional.of(LocalDate.ofEpochDay(2000L)))));
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(1L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(19L));
    }

    @Test
    public void testEmptyDateStatsToColumnStatistics() {
        DateColumnStatsData emptyDateColumnStatsData = new DateColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "date", ColumnStatisticsData.dateStats((DateColumnStatsData)emptyDateColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.of(new DateStatistics(Optional.empty(), Optional.empty())));
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testStringStatsToColumnStatistics() {
        StringColumnStatsData stringColumnStatsData = new StringColumnStatsData();
        stringColumnStatsData.setMaxColLen(100L);
        stringColumnStatsData.setAvgColLen(23.333);
        stringColumnStatsData.setNumNulls(1L);
        stringColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "string", ColumnStatisticsData.stringStats((StringColumnStatsData)stringColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(2L));
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.of(100L));
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.of(23L));
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(1L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(1L));
    }

    @Test
    public void testEmptyStringColumnStatsData() {
        StringColumnStatsData emptyStringColumnStatsData = new StringColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "string", ColumnStatisticsData.stringStats((StringColumnStatsData)emptyStringColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testBinaryStatsToColumnStatistics() {
        BinaryColumnStatsData binaryColumnStatsData = new BinaryColumnStatsData();
        binaryColumnStatsData.setMaxColLen(100L);
        binaryColumnStatsData.setAvgColLen(22.2);
        binaryColumnStatsData.setNumNulls(2L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "binary", ColumnStatisticsData.binaryStats((BinaryColumnStatsData)binaryColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(4L));
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.of(100L));
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.of(44L));
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(2L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testEmptyBinaryStatsToColumnStatistics() {
        BinaryColumnStatsData emptyBinaryColumnStatsData = new BinaryColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "binary", ColumnStatisticsData.binaryStats((BinaryColumnStatsData)emptyBinaryColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getIntegerStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDoubleStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDecimalStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getDateStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getBooleanStatistics(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxValueSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getTotalSizeInBytes(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testSingleDistinctValue() {
        DoubleColumnStatsData doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setNumNulls(10L);
        doubleColumnStatsData.setNumDVs(1L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(10L));
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(10L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(0L));
        doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setNumNulls(10L);
        doubleColumnStatsData.setNumDVs(1L);
        columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj, (OptionalLong)OptionalLong.of(11L));
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(10L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(1L));
    }

    @Test
    public void testBasicStatisticsRoundTrip() {
        TestThriftHiveMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty()));
        TestThriftHiveMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.empty(), OptionalLong.of(2L), OptionalLong.empty()));
        TestThriftHiveMetastoreUtil.testBasicStatisticsRoundTrip(new HiveBasicStatistics(OptionalLong.of(1L), OptionalLong.of(2L), OptionalLong.of(3L), OptionalLong.of(4L)));
    }

    private static void testBasicStatisticsRoundTrip(HiveBasicStatistics expected) {
        Assert.assertEquals((Object)MetastoreUtil.getHiveBasicStatistics((Map)MetastoreUtil.updateStatisticsParameters((Map)ImmutableMap.of(), (HiveBasicStatistics)expected)), (Object)expected);
    }

    @Test
    public void testGetLastDataCommitTimeFromParams() {
        Partition partition = new Partition();
        Assert.assertEquals((long)ThriftMetastoreUtil.getLastDataCommitTime((Partition)partition), (long)0L);
        partition.setParameters((Map)ImmutableMap.of((Object)"lastDataCommitTime", (Object)"1"));
        Assert.assertEquals((long)ThriftMetastoreUtil.getLastDataCommitTime((Partition)partition), (long)1L);
        partition.setParameters((Map)ImmutableMap.of((Object)"lastDataCommitTime", (Object)"a"));
        Assert.assertEquals((long)ThriftMetastoreUtil.getLastDataCommitTime((Partition)partition), (long)0L);
    }
}

