/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import com.facebook.presto.hive.authentication.NoHiveMetastoreAuthentication;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClientFactory;
import com.google.common.net.HostAndPort;
import java.util.Objects;
import java.util.Optional;
import org.apache.thrift.TException;

public class TestingHiveCluster
implements HiveCluster {
    private final MetastoreClientConfig metastoreClientConfig;
    private final HostAndPort address;

    public TestingHiveCluster(MetastoreClientConfig metastoreClientConfig, String host, int port) {
        this.metastoreClientConfig = Objects.requireNonNull(metastoreClientConfig, "metastore config is null");
        this.address = HostAndPort.fromParts((String)Objects.requireNonNull(host, "host is null"), (int)port);
    }

    public HiveMetastoreClient createMetastoreClient(Optional<String> token) throws TException {
        return new HiveMetastoreClientFactory(this.metastoreClientConfig, (HiveMetastoreAuthentication)new NoHiveMetastoreAuthentication()).create(this.address, token);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TestingHiveCluster o = (TestingHiveCluster)obj;
        return Objects.equals(this.address, o.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }
}

